/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.operations.CreateDeployPackagesJob;
import org.eclipse.stp.soas.deploy.core.ui.actions.ExecuteDeployAction;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.editors.PackageDescriptionSection;
import org.eclipse.stp.soas.internal.deploy.ui.editors.ServersSection;
import org.eclipse.stp.soas.internal.deploy.ui.editors.TargetMapSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ConfigurationPage
extends EMFFormPage {
    public static final String PAGE_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTITLE.Configuration");
    private TargetMapSection mConfiguration;
    private PackageDescriptionSection mDescription;
    private ServersSection mServers;
    private Button mCreatePackagesButton;
    private Button mDeployButton;
    private ExecuteDeployAction mDeployAction;

    public ConfigurationPage(EMFFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(PAGE_TITLE);
        GridLayout layout = EnhancedFormEditor.newPageGridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        form.getBody().setLayout((Layout)layout);
        this.createDeployButtons(managedForm);
        this.mConfiguration = new TargetMapSection(form.getBody(), toolkit, 384);
        this.mConfiguration.createClient(toolkit);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.mConfiguration.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.mConfiguration);
        this.mDescription = new PackageDescriptionSection(form.getBody(), toolkit, 386);
        this.mDescription.getSection().setExpanded(true);
        this.mDescription.createClient(toolkit);
        gd = new GridData(1808);
        this.mDescription.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.mDescription);
        this.mServers = new ServersSection(form.getBody(), toolkit, 386);
        this.mServers.getSection().setExpanded(true);
        this.mServers.createClient(toolkit);
        gd = new GridData(1808);
        this.mServers.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.mServers);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, IHelpConstants.CONTEXT_ID_CONFIGURATION_PAGE);
    }

    private void createDeployButtons(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite buttons = toolkit.createComposite(form.getBody());
        buttons.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        this.mCreatePackagesButton = toolkit.createButton(buttons, DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.BUTTON.createPackages"), 8);
        this.mCreatePackagesButton.setLayoutData((Object)new GridData(32));
        this.mCreatePackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.handleCreatePackages();
            }
        });
        this.mDeployButton = toolkit.createButton(buttons, DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.BUTTON.deployPackages"), 8);
        this.mDeployButton.setLayoutData((Object)new GridData(32));
        this.mDeployButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationPage.this.handleDeploy();
            }
        });
        this.mDeployAction = new ExecuteDeployAction(DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.action.deployPackages"), form.getShell());
        this.mDeployAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEMFFormEditor().getModelRoot()));
    }

    private void handleDeploy() {
        this.mDeployAction.run();
    }

    private void handleCreatePackages() {
        if (!DeployCorePlugin.getDefault().getWorkbench().saveAllEditors(true)) {
            return;
        }
        final CreateDeployPackagesJob createPackages = new CreateDeployPackagesJob((Root)this.getEMFFormEditor().getModelRoot());
        createPackages.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ConfigurationPage.this.handleFinish(createPackages, event.getResult());
            }
        });
        createPackages.schedule();
    }

    private void handleFinish(CreateDeployPackagesJob createPackages, IStatus status) {
        if (status.getSeverity() != 4) {
            if (status.getSeverity() == 0) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)ConfigurationPage.this.getManagedForm().getForm().getShell(), (String)DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.success.title"), (String)DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.success.message"));
                    }
                });
            } else if (status.getSeverity() != 8) {
                DeployCorePlugin.getDefault().log(status);
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)ConfigurationPage.this.getManagedForm().getForm().getShell(), (String)DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.error.title"), (String)DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.error.message"));
                    }
                });
            }
        }
    }
}

