/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentDefinitionBuilder;
import org.eclipse.stp.soas.deploy.core.operations.CreateDeployFileOperation;
import org.eclipse.stp.soas.deploy.core.ui.actions.ExecuteDeployAction;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.DeployFileDescriptionWizardPage;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.PackageSelectionWizardPage;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.PackageTargetWizardPage;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.WizardNewFileCreationPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;

public class DeployFileNewWizard
extends BaseWizard
implements INewWizard,
ISummaryDataSource {
    public static final String DEPLOY_FILE_EXTENSION = "deploy";
    private static final ImageDescriptor NEW_DEPLOY_FILE_DEFAULT_PAGE_IMAGE = ImageDescriptor.createFromURL((URL)DeployCorePlugin.getDefault().getBundle().getEntry("icons/new_wiz.gif"));
    private static final String NEW_DEPLOY_FILE_WIZARD_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.DLGTITLE");
    private static final String FILE_PAGE_NAME = "NewFilePage.name";
    private static final String FILE_PAGE_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGETITLE.FilePage");
    private static final ImageDescriptor FILE_PAGE_IMAGE = NEW_DEPLOY_FILE_DEFAULT_PAGE_IMAGE;
    private static final String FILE_PAGE_DESCRIPTION = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGEDESC.FilePage");
    private static final String DESCRIPTION_PAGE_NAME = "DescriptionPage.name";
    private static final String DESCRIPTION_PAGE_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGETITLE.DescriptionPage");
    private static final ImageDescriptor DESCRIPTION_PAGE_IMAGE = NEW_DEPLOY_FILE_DEFAULT_PAGE_IMAGE;
    private static final String DESCRIPTION_PAGE_DESCRIPTION = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGEDESC.DescriptionPage");
    private static final String PACKAGES_PAGE_NAME = "PackagesPage.name";
    private static final String PACKAGES_PAGE_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGETITLE.PackagesPage");
    private static final ImageDescriptor PACKAGES_PAGE_IMAGE = NEW_DEPLOY_FILE_DEFAULT_PAGE_IMAGE;
    private static final String PACKAGES_PAGE_DESCRIPTION = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGEDESC.PackagesPage");
    private static final String TARGETS_PAGE_NAME = "TargetsPage.name";
    private static final String TARGETS_PAGE_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGETITLE.TargetsPage");
    private static final ImageDescriptor TARGETS_PAGE_IMAGE = NEW_DEPLOY_FILE_DEFAULT_PAGE_IMAGE;
    private static final String TARGETS_PAGE_DESCRIPTION = DeployCorePlugin.getDefault().getResourceString("DeployFileNewWizard.PAGEDESC.TargetsPage");
    private WizardNewFileCreationPage mFilePage;
    private DeployFileDescriptionWizardPage mDescriptionPage;
    private PackageSelectionWizardPage mPackagesPage;
    private PackageTargetWizardPage mTargetsPage;
    private SummaryWizardPage mSummaryPage;
    private ISelection mSelection;
    private String mInitialFileName = new String();
    private IContainer mInitialContainer;
    private Root mRoot;
    static /* synthetic */ Class class$0;

    public DeployFileNewWizard() {
        this.setHelpAvailable(false);
        this.setDefaultPageImageDescriptor(NEW_DEPLOY_FILE_DEFAULT_PAGE_IMAGE);
        this.setDialogSettings(null);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NEW_DEPLOY_FILE_WIZARD_TITLE);
        this.setDialogSettings(null);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IFile file;
        if (page == this.mPackagesPage) {
            if (this.mPackagesPage.getSelection().length == 0) {
                page = this.mTargetsPage;
            }
        } else if (page == this.mFilePage && (file = this.mFilePage.getOutputFile()) != null) {
            this.mRoot.eResource().setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
        }
        return super.getNextPage(page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mSelection = selection;
        Object object = selection.getFirstElement();
        if (object != null) {
            IResource resource;
            if (object instanceof IResource) {
                resource = (IResource)object;
            } else if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            } else {
                resource = null;
            }
            if (resource != null) {
                IProject project = resource.getProject();
                this.mInitialContainer = resource.getType() == 4 ? (IProject)resource : resource.getParent();
                this.mInitialFileName = project.getName();
                if (selection.size() == 1) {
                    if (resource.getType() == 2) {
                        this.mInitialContainer = (IFolder)resource;
                        this.mInitialFileName = resource.getName();
                    } else if (resource.getType() == 1) {
                        this.mInitialFileName = resource.getFullPath().removeFileExtension().lastSegment();
                    }
                }
            }
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource dummyResource = rs.createResource(URI.createPlatformResourceURI((String)"/dummy/dummy.deploy"));
        this.mRoot = DeployFilePackage.eINSTANCE.getDeployFileFactory().createRoot();
        dummyResource.getContents().add((Object)this.mRoot);
    }

    public IFile[] getSelectedPackages() {
        return this.mPackagesPage.getSelection();
    }

    public IFile getOutputFile() {
        return this.mFilePage.getOutputFile();
    }

    public void addPages() {
        this.mFilePage = new WizardNewFileCreationPage(FILE_PAGE_NAME, FILE_PAGE_TITLE, FILE_PAGE_IMAGE);
        this.mFilePage.setDescription(FILE_PAGE_DESCRIPTION);
        this.mFilePage.init(DEPLOY_FILE_EXTENSION, (ISelection)(this.mInitialContainer == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)this.mInitialContainer)));
        this.mFilePage.setFileName(this.mInitialFileName);
        this.addPage((IWizardPage)this.mFilePage);
        this.mDescriptionPage = new DeployFileDescriptionWizardPage(DESCRIPTION_PAGE_NAME, DESCRIPTION_PAGE_TITLE, DESCRIPTION_PAGE_IMAGE);
        this.mDescriptionPage.setDescription(DESCRIPTION_PAGE_DESCRIPTION);
        this.mDescriptionPage.init(this.mRoot);
        this.addPage((IWizardPage)this.mDescriptionPage);
        this.mPackagesPage = new PackageSelectionWizardPage(PACKAGES_PAGE_NAME, PACKAGES_PAGE_TITLE, PACKAGES_PAGE_IMAGE);
        this.mPackagesPage.setDescription(PACKAGES_PAGE_DESCRIPTION);
        this.mPackagesPage.init(this.mRoot, this.mSelection);
        this.addPage((IWizardPage)this.mPackagesPage);
        this.mTargetsPage = new PackageTargetWizardPage(TARGETS_PAGE_NAME, TARGETS_PAGE_TITLE, TARGETS_PAGE_IMAGE);
        this.mTargetsPage.setDescription(TARGETS_PAGE_DESCRIPTION);
        this.mTargetsPage.init(this.mRoot);
        this.addPage((IWizardPage)this.mTargetsPage);
        this.mSummaryPage = new SummaryWizardPage((ISummaryDataSource)this);
        this.addPage((IWizardPage)this.mSummaryPage);
    }

    public boolean performFinish() {
        final IFile file = this.getOutputFile();
        final String name = this.mDescriptionPage.getDeployName();
        final String description = this.mDescriptionPage.getDeployDescription();
        final boolean execute = this.mTargetsPage.getExecuteDeployment();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DeployFileNewWizard.this.installBuilder(monitor);
                monitor.beginTask(DeployCorePlugin.getDefault().getResourceString("TASK.CreatingFile", new Object[]{file.getName()}), 2);
                DeployFileNewWizard.this.mRoot.setName(name);
                DeployFileNewWizard.this.mRoot.setDescription(description);
                new CreateDeployFileOperation(file, DeployFileNewWizard.this.mRoot).run(monitor);
                if (!execute) {
                    monitor.worked(1);
                    monitor.setTaskName(DeployCorePlugin.getDefault().getResourceString("TASK.OpeningFile"));
                    DeployFileNewWizard.this.getShell().getDisplay().asyncExec(new Runnable(this, file){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IFile val$file;
                        {
                            this.this$1 = var1_1;
                            this.val$file = iFile;
                        }

                        public void run() {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)this.val$file, (boolean)true);
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)DeployCorePlugin.getDefault().getResourceString("DLGTITLE.Error"), (String)realException.getMessage());
            return false;
        }
        if (execute) {
            ExecuteDeployAction action = new ExecuteDeployAction(new String(), this.getShell());
            action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.mRoot));
            action.run();
        }
        return true;
    }

    private void installBuilder(IProgressMonitor monitor) {
        try {
            boolean foundBuilder = false;
            IProject project = this.getOutputFile().getProject();
            IProjectDescription projDesc = project.getDescription();
            ArrayList<ICommand> builders = new ArrayList<ICommand>(Arrays.asList(projDesc.getBuildSpec()));
            Iterator it = builders.iterator();
            while (!foundBuilder && it.hasNext()) {
                foundBuilder = DeploymentDefinitionBuilder.BUILDER_ID.equals(((ICommand)it.next()).getBuilderName());
            }
            if (!foundBuilder) {
                ICommand packageBuilder = projDesc.newCommand();
                packageBuilder.setBuilderName(DeploymentDefinitionBuilder.BUILDER_ID);
                builders.add(packageBuilder);
                projDesc.setBuildSpec(builders.toArray(new ICommand[builders.size()]));
                project.setDescription(projDesc, monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

