/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.EmptyContainerFilter;
import org.eclipse.stp.soas.internal.deploy.ui.PackagesFilter;
import org.eclipse.stp.soas.internal.deploy.ui.ProjectsFilter;
import org.eclipse.stp.soas.internal.deploy.ui.viewers.CheckboxTreeViewer;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.DeployFileNewWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PackageSelectionWizardPage
extends WizardPage
implements ISummaryDataSource {
    public static final String LABEL_SELECT_PACKAGES = DeployCorePlugin.getDefault().getResourceString("LABEL.SelectPackages");
    public static final int MIN_TREE_HEIGHT = 15;
    private ProjectsFilter mProjectsFilter = new ProjectsFilter(null);
    private CheckboxTreeViewer mPackageViewer;
    private ISelection mSelection;

    public PackageSelectionWizardPage(String pageName) {
        super(pageName);
    }

    public PackageSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void init(Root root, ISelection selection) {
        this.mSelection = selection;
    }

    public void setSourceProject(IProject sourceProject) {
        Object[] checked = this.mPackageViewer.getCheckedLeafElements();
        if (this.mProjectsFilter.setSourceProject(sourceProject)) {
            this.mPackageViewer.refresh();
            this.mPackageViewer.setCheckedElements(checked);
            this.validate();
        }
    }

    public void createControl(Composite parent) {
        PackagesFilter packagesFilter = new PackagesFilter();
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(1808));
        Label label = new Label(content, 0);
        label.setText(LABEL_SELECT_PACKAGES);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.mPackageViewer = new CheckboxTreeViewer(content, 2816);
        this.mPackageViewer.setAutoExpandLevel(3);
        this.mPackageViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.mPackageViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.mPackageViewer.addFilter((ViewerFilter)packagesFilter);
        this.mPackageViewer.addFilter((ViewerFilter)this.mProjectsFilter);
        this.mPackageViewer.addFilter((ViewerFilter)new EmptyContainerFilter());
        data = new GridData(1808);
        data.heightHint = this.mPackageViewer.getTree().getItemHeight() * MIN_TREE_HEIGHT;
        this.mPackageViewer.getTree().setLayoutData((Object)data);
        this.mPackageViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PackageSelectionWizardPage.this.handleCheckStateChanged(event);
            }
        });
        this.initControls();
        this.setControl((Control)content);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setSourceProject(((DeployFileNewWizard)this.getWizard()).getOutputFile().getProject());
        }
        super.setVisible(visible);
    }

    public IFile[] getSelection() {
        Object[] selection = this.mPackageViewer.getCheckedElements();
        Vector<IResource> files = new Vector<IResource>(selection.length);
        int index = 0;
        int count = selection.length;
        while (index < count) {
            IResource res = (IResource)selection[index];
            int resType = res.getType();
            if (resType == 1) {
                files.add(res);
            }
            ++index;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public List getSummaryData() {
        IFile[] packages = this.getSelection();
        ArrayList<String[]> summaryData = new ArrayList<String[]>(packages.length + 1);
        summaryData.add(new String[]{DeployCorePlugin.getDefault().getResourceString("PackageSelectionWizardPage.summary.selectedPackages"), new String()});
        int index = 0;
        int count = packages.length;
        while (index < count) {
            summaryData.add(new String[]{new String(), packages[index].getFullPath().toString()});
            ++index;
        }
        return summaryData;
    }

    private void initControls() {
        this.mPackageViewer.setInput((Object)DeployCorePlugin.getWorkspace().getRoot());
        this.mPackageViewer.setCheckedElements(((IStructuredSelection)this.mSelection).toArray());
        this.updateControls();
        this.validate();
    }

    private void updateControls() {
    }

    private void validate() {
        if (this.getSelection().length > 0) {
            this.setMessage(null, 2);
        } else {
            this.setMessage(DeployCorePlugin.getDefault().getResourceString("TEXT.NoPackagesWarning"), 2);
        }
        this.setPageComplete(true);
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        this.updateControls();
        this.validate();
    }
}

