/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.operations;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.internal.deploy.core.PackageCreationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class CreatePackageJob
extends Job {
    private ILogicalPackage mPackage;
    private IPackageConstructorExtension mConstructor;
    private IPackageCreationContext mContext;
    private IPackageConfiguration mConfiguration;

    public CreatePackageJob(ILogicalPackage pkg, IPackageConstructorExtension constructor, IPackageConfiguration configuration) {
        super(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.task.name"));
        this.mPackage = pkg;
        this.mConstructor = constructor;
        this.mConfiguration = configuration;
        this.setRule((ISchedulingRule)this.mPackage.getFile().getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    public CreatePackageJob(ILogicalPackage pkg, IPackageConstructorExtension constructor) {
        this(pkg, constructor, null);
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.task.name"), 1000);
        try {
            this.buildWorkspace(monitor);
            this.checkCancelled(monitor);
            this.checkForErrors(monitor);
            this.checkCancelled(monitor);
            this.createPackage(monitor);
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.action.name")){

                public void run() {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    display.syncExec(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        /*
                         * Exception decompiling
                         */
                        public void run() {
                            /*
                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                             * 
                             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 120->124)] java.lang.Throwable
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype.dumpAppropriatelyCastedArgumentString(MethodPrototype.java:562)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.MemberFunctionInvokation.dumpInner(MemberFunctionInvokation.java:63)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype.dumpAppropriatelyCastedArgumentString(MethodPrototype.java:562)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.MemberFunctionInvokation.dumpInner(MemberFunctionInvokation.java:63)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.dump(StructuredTry.java:79)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                             *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                             *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                             *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                             *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                             */
                            throw new IllegalStateException("Decompilation failed");
                        }
                    });
                }

                static /* synthetic */ CreatePackageJob access$0(1 var0) {
                    return var0.CreatePackageJob.this;
                }
            });
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        catch (InterruptedException interruptedException) {
            status = Status.CANCEL_STATUS;
        }
        monitor.done();
        return status;
    }

    private void buildWorkspace(IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor buildMonitor = new SubProgressMonitor(monitor, 400);
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.subtask.build"));
        this.mPackage.getFile().getWorkspace().build(10, (IProgressMonitor)buildMonitor);
        buildMonitor.done();
    }

    private void checkForErrors(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.subtask.errorCheck"));
        IStatus[] validateStatus = this.mConstructor.validatePackage(this.mPackage, this.mConfiguration, null);
        if (validateStatus != null && validateStatus.length > 0) {
            MultiStatus status = new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, validateStatus, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.message.log.buildPackage"), null);
            if (status.getSeverity() == 4) {
                throw new CoreException((IStatus)status);
            }
            status.getSeverity();
        }
        monitor.worked(100);
    }

    private void createPackage(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.subtask.createPackage"));
        this.mContext = new PackageCreationContext(null, DeploymentExtensionManager.getInstance().getOutputFolder(this.mPackage, this.mConstructor.getDeployDriver()).getLocation().toFile(), this.createTempFolder());
        if (!this.mContext.getOutputFolder().exists()) {
            this.mContext.getOutputFolder().mkdirs();
        }
        this.mConstructor.createPackage(this.mPackage, this.mContext, this.mConfiguration);
        this.deleteFile(this.mContext.getTempFolder());
        monitor.worked(500);
    }

    private void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private File createTempFolder() throws CoreException {
        try {
            File tmpFile = File.createTempFile("deploy_temp", ".tmp");
            File tempFolder = new File(tmpFile.getParentFile(), tmpFile.getName().substring(0, tmpFile.getName().lastIndexOf(".tmp")));
            tempFolder.mkdir();
            tmpFile.deleteOnExit();
            tempFolder.deleteOnExit();
            return tempFolder;
        }
        catch (IOException e) {
            Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("CreatePackageJob.error.tempDir"), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void deleteFile(File file) {
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            int index = 0;
            int count = files.length;
            while (index < count) {
                this.deleteFile(files[index]);
                ++index;
            }
        }
        file.delete();
    }

    static /* synthetic */ ILogicalPackage access$0(CreatePackageJob createPackageJob) {
        return createPackageJob.mPackage;
    }
}

