/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.ui.actions;

import java.util.Random;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.ui.actions.ExecuteDeployAction;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFileFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.ServerSelectionDialogPage;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DeployPackageActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection mSelection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(Event event) {
        this.run((IAction)null);
    }

    public void run(IAction action) {
        if (this.mSelection == null || !(this.mSelection.getFirstElement() instanceof IPackage)) {
            return;
        }
        IPackage thePackage = (IPackage)this.mSelection.getFirstElement();
        Root root = DeployFileFactory.eINSTANCE.createRoot();
        DeployPackage deployPackage = DeployFileFactory.eINSTANCE.createDeployPackage(root, thePackage.getFile().getProjectRelativePath().toString());
        DeployConfiguration deployConfig = DeployFileFactory.eINSTANCE.createDeployConfiguration(null, deployPackage);
        ServerSelectionDialogPage page = new ServerSelectionDialogPage();
        Dialog dialog = new Dialog(DeployCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IDialogPage)page);
        page.init(deployPackage, thePackage, null);
        if (dialog.open() == 0) {
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource resource = rs.createResource(this.createDeployResourceURI(thePackage));
            DeployServer target = page.getSelectedDeployServer();
            resource.getContents().add((Object)root);
            root.getServer().add((Object)target);
            deployConfig.setTargetServer(target);
            ExecuteDeployAction deployAction = new ExecuteDeployAction(new String(), DeployCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell());
            deployAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)root));
            deployAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.mSelection = (IStructuredSelection)selection;
        }
    }

    private URI createDeployResourceURI(IPackage thePackage) {
        IPath pkgPath = thePackage.getFile().getFullPath();
        String pkgName = pkgPath.removeFileExtension().lastSegment();
        String deployName = String.valueOf(pkgName) + '_' + Math.abs(new Random().nextInt());
        IPath deployPath = pkgPath.removeLastSegments(1).append(deployName).addFileExtension("deploy");
        return URI.createPlatformResourceURI((String)deployPath.toString());
    }
}

