/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IServerDefinition;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyMap;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.MatchRule;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.internal.deploy.core.MergedSupportedTechnologyType;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.ServerDefinition;
import org.eclipse.stp.soas.internal.deploy.core.SupportedTechnologyType;

public class TechnologyMap
implements ITechnologyMap {
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_MATCH_RULE = "matchRule";
    private IConfigurationElement mElement;
    private String mServerDef;
    private IVersion mServerVersion;
    private MatchRule mMatchRule;
    private SortedMap mSupportedTechnologiesByDef;

    public TechnologyMap(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
    }

    public ISupportedTechnologyType[] getSupportedTechnologyTypes() {
        return this.mSupportedTechnologiesByDef.values().toArray(new ISupportedTechnologyType[this.mSupportedTechnologiesByDef.size()]);
    }

    public IServerDefinition getServerDefinition() {
        return DeploymentExtensionManager.getInstance().getServerDefinition(this.mServerDef);
    }

    public IVersion getServerVersion() {
        return this.mServerVersion;
    }

    public MatchRule getVersionMatchRule() {
        return this.mMatchRule;
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        Assert.isTrue((boolean)"technologyMap".equals(element.getName()));
        if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.out.println(DeployCorePlugin.getDefault().getResourceString("TechnologyMap.trace.processingTechnologyMap", new Object[]{element.getDeclaringExtension().getContributor().getName()}));
            System.out.flush();
        }
        this.mElement = element;
        this.processAttributes();
        this.processSupportedTechnologyElements();
        ((ServerDefinition)this.getServerDefinition()).addTechnologyMap(this);
    }

    private void processAttributes() throws PackageExtensionException {
        this.mServerDef = this.mElement.getAttribute(ATTR_TYPE);
        this.mServerVersion = Version.valueOf(this.mElement.getAttribute(ATTR_VERSION));
        String matchRuleAttr = this.mElement.getAttribute(ATTR_MATCH_RULE);
        if (matchRuleAttr == null || MatchRule.valueOf(matchRuleAttr.trim()) == null) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.out.println(DeployCorePlugin.getDefault().getResourceString("TechnologyMap.trace.matchRuleNotSpecified"));
                System.out.flush();
            }
            this.mMatchRule = MatchRule.EQUIVALENT;
        } else {
            this.mMatchRule = MatchRule.valueOf(matchRuleAttr.trim());
        }
        if (this.mServerDef == null) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("TechnologyMap.trace.error.typeAttributeNotSpecified", new Object[]{this.mElement.getDeclaringExtension().getContributor().getName()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("TechnologyMap.exception.technologyMapParseError"));
        }
        if (DeploymentExtensionManager.getInstance().getServerDefinition(this.mServerDef) == null) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("TechnologyMap.trace.error.invalidTypeSpecified", new Object[]{this.mElement.getDeclaringExtension().getContributor().getName()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("TechnologyMap.exception.invalidTypeSpecified"));
        }
    }

    private void processSupportedTechnologyElements() {
        IConfigurationElement[] supportedTechnologies = this.mElement.getChildren("supportedTechnology");
        this.mSupportedTechnologiesByDef = new TreeMap();
        int index = 0;
        int count = supportedTechnologies.length;
        while (index < count) {
            block4: {
                try {
                    ISupportedTechnologyType istt = new SupportedTechnologyType(supportedTechnologies[index]);
                    ISupportedTechnologyType existingIstt = (ISupportedTechnologyType)this.mSupportedTechnologiesByDef.get(istt.getTechnologyDefinition());
                    if (existingIstt != null) {
                        istt = new MergedSupportedTechnologyType(existingIstt, istt);
                    }
                    this.mSupportedTechnologiesByDef.put(istt.getTechnologyDefinition(), istt);
                }
                catch (PackageExtensionException e) {
                    if (!DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) break block4;
                    System.err.println(DeployCorePlugin.getDefault().getResourceString("TechnologyMap.trace.error.supportedTechnologyParseError", new Object[]{this.mServerDef, this.mServerVersion, this.mElement.getDeclaringExtension().getContributor().getName()}));
                    e.printStackTrace();
                    System.err.flush();
                }
            }
            ++index;
        }
    }
}

