/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.Version;

public class TechnologyType
implements ITechnologyType {
    private String mTechnologyDef;
    private Version mVersion;

    public TechnologyType(String technologyDef, Version version) {
        if (DeploymentExtensionManager.getInstance().getTechnologyDefinition(technologyDef) == null) {
            throw new IllegalArgumentException(DeployCorePlugin.getDefault().getResourceString("TechnologyType.exception.technologyDefinitionDoesNotExist", new Object[]{technologyDef}));
        }
        this.mTechnologyDef = technologyDef;
        this.mVersion = version;
    }

    public ITechnologyDefinition getTechnologyDefinition() {
        return DeploymentExtensionManager.getInstance().getTechnologyDefinition(this.mTechnologyDef);
    }

    public IVersion getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return DeployCorePlugin.getDefault().getResourceString("TechnologyType.toString", new Object[]{this.mTechnologyDef, this.mVersion});
    }

    public boolean equals(Object obj) {
        boolean retVal;
        if (this == obj) {
            retVal = true;
        } else if (obj instanceof TechnologyType) {
            TechnologyType tt = (TechnologyType)obj;
            retVal = this.mTechnologyDef.equals(tt.mTechnologyDef) && this.mVersion.equals(tt.mVersion);
        } else {
            retVal = false;
        }
        return retVal;
    }

    public int hashCode() {
        return this.mTechnologyDef.hashCode();
    }
}

