/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.internal.deploy.emf.AdapterFactoryContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TargetMapTreeViewer {
    public static final String LABEL_UNSPECIFIED_TARGET = DeployCorePlugin.getDefault().getResourceString("LABEL.unspecifiedTarget");
    private TreeViewer mPackages;

    public TargetMapTreeViewer(Tree tree) {
        this.createControl(tree);
    }

    public TreeViewer getViewer() {
        return this.mPackages;
    }

    private void createControl(Tree tree) {
        this.mPackages = new TreeViewer(tree);
        this.mPackages.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mPackages.setLabelProvider((IBaseLabelProvider)new TargetMapLabelProvider((AdapterFactory)Utilities.getItemAdapterFactory()));
        this.mPackages.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof DeployPackage || element instanceof DeployConfiguration;
            }
        });
    }

    private static class TargetMapLabelProvider
    extends AdapterFactoryLabelProvider {
        private ILabelProvider mWorkbenchLabelProvider = new WorkbenchLabelProvider();
        static /* synthetic */ Class class$0;

        public TargetMapLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getImage(Object element) {
            Image image = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IItemLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterFactory.adapt(element, (Object)clazz);
            if (element instanceof DeployPackage) {
                IPackage ip = Utilities.adaptToIPackage((EObject)((DeployPackage)element));
                image = ip == null ? super.getImage(element) : this.mWorkbenchLabelProvider.getImage((Object)ip.getFile());
            } else if (element instanceof DeployConfiguration) {
                DeployConfiguration config = (DeployConfiguration)element;
                IConnectionProfile cp = Utilities.adaptToIConnectionProfile((EObject)config);
                image = cp == null ? super.getImage((Object)config.getTargetServer()) : ProfileImageRegistry.getInstance().getProfileImage(cp.getProvider());
            }
            return image;
        }

        public String getText(Object element) {
            DeployConfiguration config;
            IConnectionProfile cp;
            IPackage ip;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IItemLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterFactory.adapt(element, (Object)clazz);
            String text = element instanceof DeployPackage ? ((ip = Utilities.adaptToIPackage((EObject)((DeployPackage)element))) == null ? super.getText(element) : ip.getFile().getFullPath().toString()) : (element instanceof DeployConfiguration ? ((cp = Utilities.adaptToIConnectionProfile((EObject)(config = (DeployConfiguration)element))) == null ? (config.getTargetServer() == null || config.getTargetServer().getProfileName() == null ? LABEL_UNSPECIFIED_TARGET : config.getTargetServer().getProfileName()) : cp.getName()) : super.getText(element));
            return text;
        }

        public void dispose() {
            this.mWorkbenchLabelProvider.dispose();
            super.dispose();
        }
    }
}

