/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.soas.internal.deploy.ui.SharedImages;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class FormOutlinePage
extends ContentOutlinePage {
    private EnhancedFormEditor mEditor;
    private boolean mProcessingSetSelection = false;

    public FormOutlinePage(EnhancedFormEditor editor) {
        this.mEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.createContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.getTreeViewer().setInput((Object)this.mEditor);
        this.getTreeViewer().setAutoExpandLevel(-1);
        this.mEditor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSelection(ISelection selection) {
        if (this.mProcessingSetSelection) return;
        try {
            this.mProcessingSetSelection = true;
            super.setSelection(selection);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.mProcessingSetSelection = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.mProcessingSetSelection = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectionChanged(SelectionChangedEvent event) {
        if (this.mProcessingSetSelection) return;
        try {
            this.mProcessingSetSelection = true;
            if (event.getSelectionProvider() == this.getTreeViewer()) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                this.updateEditor(selection);
                this.fireSelectionChanged((ISelection)selection);
            } else {
                this.updateOutline((IStructuredSelection)event.getSelection());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.mProcessingSetSelection = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.mProcessingSetSelection = false;
            return;
        }
    }

    public void dispose() {
        this.mEditor.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
    }

    public EnhancedFormEditor getEditor() {
        return this.mEditor;
    }

    protected ITreeContentProvider createContentProvider() {
        return new FormContentProvider();
    }

    protected ILabelProvider createLabelProvider() {
        return new FormLabelProvider();
    }

    protected IFormPage getParentPage(IStructuredSelection selection) {
        IFormPage page = selection.isEmpty() || !(selection.getFirstElement() instanceof IFormPage) ? null : (IFormPage)selection.getFirstElement();
        return page;
    }

    protected void updateOutline(IStructuredSelection selection) {
        IFormPage activePage = this.mEditor.getActivePageInstance();
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)activePage), true);
    }

    protected void updateEditor(IStructuredSelection selection) {
        IFormPage activePage = this.mEditor.getActivePageInstance();
        IFormPage selectionPage = this.getParentPage(selection);
        if (selectionPage != null) {
            if (activePage != selectionPage) {
                this.mEditor.setActivePage(selectionPage.getId());
            }
            if (selectionPage != null) {
                selectionPage.selectReveal((Object)selection);
            }
        }
    }

    public class FormContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            Object[] children = parentElement instanceof EnhancedFormEditor ? ((EnhancedFormEditor)((Object)parentElement)).getPages() : new Object[]{};
            return children;
        }

        public Object getParent(Object element) {
            IFormPage parent = element instanceof IFormPage ? (IFormPage)element : null;
            return parent;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class FormLabelProvider
    extends LabelProvider {
        private Image mPageImage;

        public void dispose() {
            if (this.mPageImage != null) {
                this.mPageImage.dispose();
                this.mPageImage = null;
            }
            super.dispose();
        }

        public Image getImage(Object element) {
            Image image = element instanceof IFormPage ? this.getPageImage() : super.getImage(element);
            return image;
        }

        public String getText(Object element) {
            String text = element instanceof IFormPage ? ((IFormPage)element).getTitle() : super.getText(element);
            return text;
        }

        protected Image getPageImage() {
            if (this.mPageImage == null) {
                this.mPageImage = SharedImages.getImageDescriptor("PROPERTIES", "16").createImage();
            }
            return this.mPageImage;
        }
    }
}

