/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf;

import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

/**
 * Fixes problems in EMF supplied NotifyChangedToViewerRefresh class. This class
 * used viewer add/remove methods when responding to model changes. This causes
 * the objects displayed in the viewer to be out of sync with the model (e.g.
 * when objects are created in the model they may be added to the viewer even if
 * they are not direct children of the input).
 * 
 * @see org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh
 * 
 * @author rcernich
 * 
 * Created on Feb 24, 2004
 */
public class NotifyChangedToViewerRefresh extends
		org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh {

	public static void handleNotifyChanged(final Viewer viewer,
			final Object object, final int eventType, final Object feature,
			final Object oldValue, final Object newValue, final int index) {
		if (viewer.getControl() == null || viewer.getControl().isDisposed())
			return;
		Display d = viewer.getControl().getDisplay();
		if (d != Display.getCurrent()) {
			d.asyncExec(new Runnable() {

				public void run() {
					if (viewer.getControl() != null
							&& !viewer.getControl().isDisposed()) {
						new NotifyChangedToViewerRefresh().refresh(viewer,
								object, eventType, feature, oldValue, newValue,
								index);
					}
				}
			});
		}
		else {
			new NotifyChangedToViewerRefresh().refresh(viewer, object,
					eventType, feature, oldValue, newValue, index);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh#refreshListViewer(org.eclipse.jface.viewers.ListViewer,
	 *      java.lang.Object, int, java.lang.Object, java.lang.Object,
	 *      java.lang.Object, int)
	 */
	public void refreshListViewer(ListViewer viewer, Object object,
			int eventType, Object feature, Object oldValue, Object newValue,
			int index) {
		// super.refreshListViewer() blindly adds/removes objects from the
		// List regardless of whether or not they are children of the List's
		// input.
		refreshStructuredViewer(viewer, object, eventType, feature, oldValue,
				newValue, index);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh#refreshTableViewer(org.eclipse.jface.viewers.TableViewer,
	 *      java.lang.Object, int, java.lang.Object, java.lang.Object,
	 *      java.lang.Object, int)
	 */
	public void refreshTableViewer(TableViewer viewer, Object object,
			int eventType, Object feature, Object oldValue, Object newValue,
			int index) {
		// super.refreshTableViewer() blindly adds/removes objects from the
		// Table regardless of whether or not they are children of the Table's
		// input.
		refreshStructuredViewer(viewer, object, eventType, feature, oldValue,
				newValue, index);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh#refreshTreeViewer(org.eclipse.jface.viewers.TreeViewer,
	 *      java.lang.Object, int, java.lang.Object, java.lang.Object,
	 *      java.lang.Object, int)
	 */
	public void refreshTreeViewer(TreeViewer viewer, Object object,
			int eventType, Object feature, Object oldValue, Object newValue,
			int index) {
		refreshStructuredViewer(viewer, object, eventType, feature, oldValue,
				newValue, index);
	}

	public void refreshTableTreeViewer(TableTreeViewer viewer, Object object,
			int eventType, Object feature, Object oldValue, Object newValue,
			int index) {
		refreshStructuredViewer(viewer, object, eventType, feature, oldValue,
				newValue, index);
	}

	public void refreshStructuredViewer(StructuredViewer viewer, Object object,
			int eventType, Object feature, Object oldValue, Object newValue,
			int index) {
		refreshViewer(viewer, object, eventType, feature, oldValue, newValue,
				index);
	}
}