/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.controls;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

/**
 * @author rcernich
 * 
 * Created on Oct 13, 2004
 */
public abstract class EMFControl {

	private Control mControl;
	private EObject mOwner;
	private EStructuralFeature mFeature;
	private Adapter mModelListener;

	public EMFControl(Control control, EStructuralFeature feature) {
		super();
		mControl = control;
		mOwner = null;
		mFeature = feature;
		mModelListener = new ModelListener();

		addDisposeListener();
	}

	public Control getControl() {
		return mControl;
	}

	public EObject getOwner() {
		return mOwner;
	}

	public void setOwner(EObject owner) {
		removeModelListener();
		mOwner = owner;
		addModelListener();
		setControlValue(getModelValue());
	}

	public EStructuralFeature getFeature() {
		return mFeature;
	}

	public abstract Object getControlValue();

	public abstract void setControlValue(Object value);

	public Object getModelValue() {
		Object retVal;
		if (mOwner == null) {
			retVal = null;
		}
		else {
			retVal = mOwner.eGet(mFeature);
		}
		return retVal;
	}

	public void setModelValue(Object value) {
		Object curValue = getControlValue();
		if (mOwner != null
				&& ((curValue != null && !curValue.equals(value)) || (curValue == null && value != null))) {
			EditingDomain domain = getEditingDomain();
			if (domain == null) {
				mOwner.eSet(mFeature, value);
			}
			else {
				domain.getCommandStack().execute(
						SetCommand.create(domain, mOwner, mFeature, value));
			}
		}
	}

	public EditingDomain getEditingDomain() {
		EditingDomain retVal;
		if (mOwner == null) {
			retVal = null;
		}
		else {
			retVal = AdapterFactoryEditingDomain.getEditingDomainFor(mOwner);
		}
		return retVal;
	}

	private void addModelListener() {
		if (mOwner != null) {
			mOwner.eAdapters().add(mModelListener);
		}
	}

	private void removeModelListener() {
		if (mOwner != null) {
			mOwner.eAdapters().remove(mModelListener);
		}
	}

	private void addDisposeListener() {
		mControl.addDisposeListener(new DisposeListener() {

			public void widgetDisposed(DisposeEvent e) {
				removeModelListener();
			}
		});
	}

	private class ModelListener extends AdapterImpl {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
		 */
		public void notifyChanged(Notification notification) {
			super.notifyChanged(notification);

			if (!notification.isTouch()) {
				Object controlValue = getControlValue();
				Object modelValue = getModelValue();
				if ((controlValue != null && !controlValue.equals(modelValue))
						|| (controlValue == null && modelValue != null)) {
					setControlValue(modelValue);
				}
			}
		}
	}
}