/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public interface IReferenceNameChangeExtension {

	/**
	 * @return the feature containing the resource reference
	 */
	public EStructuralFeature getFeature();

	/**
	 * @param object
	 * @param referenceValue the value of the reference. The exact type is
	 *        dependent upon the type defined for the feature in the EMF model.
	 * 
	 * @return the IResource referenced by the value
	 */
	public IResource getReferencedResource(EObject object, Object referenceValue);

	/**
	 * The implementer should update the object according to the information in
	 * the resource delta.
	 * 
	 * @param object the object to be updated
	 * @param delta the resource delta containing the changes
	 */
	public void updateReference(EObject object, IResourceDelta delta);

}
