/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.refactoring;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * Use for references stored as project relative paths in string objects.
 * 
 * @author rcernich
 * 
 * Created on Sep 28, 2005
 */

public class ProjectRelativeNameChangeExtension implements
		IReferenceNameChangeExtension {

	private EStructuralFeature mFeature;

	public ProjectRelativeNameChangeExtension(EStructuralFeature feature) {
		super();

		mFeature = feature;
	}

	public EStructuralFeature getFeature() {
		return mFeature;
	}

	public IResource getReferencedResource(EObject object, Object referenceValue) {
		if (object.eResource() == null || referenceValue == null) {
			return null;
		}

		IResource source = ResourceNameChangeAdapter
				.getWorkspaceResource(object.eResource().getURI());
		if (source == null) {
			return null;
		}

		IResource retVal = source.getProject().getFile((String) referenceValue);
		if (!retVal.exists()) {
			try {
				IProject[] projects = source.getProject()
						.getReferencedProjects();
				for (int index = 0, count = projects.length; index < count
						&& !retVal.exists(); ++index) {
					retVal = projects[index].getFile((String) referenceValue);
				}
			}
			catch (CoreException e) {
				e.printStackTrace();
			}

			if (!retVal.exists()) {
				retVal = null;
			}
		}

		return retVal;

	}

	public void updateReference(EObject object, IResourceDelta delta) {
		IResource newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(
				delta.getMovedToPath());
		if (newFile == null) {
			// RJC: TODO: might want to log something
			return;
		}

		if (mFeature.isMany()) {
			List list = (List) object.eGet(mFeature);
			int index = list.indexOf(delta.getResource()
					.getProjectRelativePath().toString());
			if (index < 0) {
				// RJC: TODO: might want to log something
				return;
			}

			list.set(index, newFile.getProjectRelativePath().toString());
		}
		else {
			object.eSet(mFeature, newFile.getProjectRelativePath().toString());
		}
	}

}
