/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stp.soas.internal.deploy.util.DeployUtilPlugin;
import org.eclipse.swt.graphics.Image;


/**
 * @author karl
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class SharedImages implements ISharedGraphicConstants
{

	public final static String ICONS_PATH = "icons/";//$NON-NLS-1$
	
	/** Icon size is 16x16 **/
	public final static String SIZE_NONE = "0"; //$NON-NLS-1$
	/** Icon size is 16x16 **/
	public final static String SIZE_16 = "16"; //$NON-NLS-1$
	/** Icon size is 32x32 **/
	public final static String SIZE_32 = "32"; //$NON-NLS-1$
	/** Icon size is 48x48 **/
	public final static String SIZE_48 = "48"; //$NON-NLS-1$
	

	private static Map descriptors = new HashMap();
	private static ImageRegistry imageRegistry;
    private static ImageDescriptorRegistry imageDescriptorRegistry;
	private static DeployUtilPlugin plugin = DeployUtilPlugin.getDefault();

	/**
	 * Returns the ImageRegistry.
	 */
	public static ImageRegistry getImageRegistry() 
	{
		if (imageRegistry == null) 
		{
			initializeImageRegistry();
		}
		return imageRegistry;
	}

	/**
	 * initialize the image registry with all required images
	 */
	public static ImageRegistry initializeImageRegistry() 
	{
		imageRegistry = new ImageRegistry();
		loadImages();
		return imageRegistry;
	}

	/**
	 * load an image descriptor
	 */
	public final static ImageDescriptor getImageDescriptor(String symbolicName, String size)
	{
		
		ImageDescriptor desc = null;
		try
		{
			String path;
			if (size.compareToIgnoreCase(SIZE_NONE) == 0)
				path = ICONS_PATH + symbolicName + ".gif"; //$NON-NLS-1$
			else
				path = ICONS_PATH + symbolicName + "_" + size + ".gif"; //$NON-NLS-1$ //$NON-NLS-2$
			
			desc = ImageDescriptor.createFromURL(plugin.getBundle().getEntry(path));
			if (desc.getImageData() == null)				
				desc = ImageDescriptor.getMissingImageDescriptor();
		}
		catch(Exception e)
		{
			desc = ImageDescriptor.getMissingImageDescriptor();
		}

		return desc;
	}	

	/**
	 * load an image descriptors into a hashmap so that they can be accessed and loaded into the
	 * image registry only when called
	 */
	private final static void loadImageDescriptor(String key, String size)
	{
		descriptors.put(key + "_" + size,  getImageDescriptor(key, size));	 //$NON-NLS-1$
	}

	/**
	 * load this images definition into a map so that we can load it quickly into the
	 * registry only if its ever called
	 */
	public final static Image getImage(String symbolicName, String size)
	{
		if (imageRegistry == null) 
		{
			initializeImageRegistry();
		}		
		
		// create the key
		String symName = symbolicName.toUpperCase();
		String key = symName + "_" + size; //$NON-NLS-1$
		key = key.toUpperCase();		
		
		// see if the image is loaded
		Image img = imageRegistry.get(key);
		if (img == null)
		{
			// no so load it
			ImageDescriptor desc = null;
			
			try
			{
				desc = (ImageDescriptor) descriptors.get(key);
				img = desc.createImage();
				imageRegistry.put(key, img);
			}
			catch (Exception e)
			{
				loadImageDescriptor(symName, size);
				desc = (ImageDescriptor) descriptors.get(key);
				img = desc.createImage();
				imageRegistry.put(key, img);
			}
		}
			
		return img;		
	}

	/**
	 * cache the image descriptors
	 */
	private static void loadImages()
	{
		loadImageDescriptor(ISharedGraphicConstants.IMG_PROPERTIES, SIZE_16);
	}

    public synchronized final static ImageDescriptorRegistry getImageDescriptorRegistry()
    {
        if (imageDescriptorRegistry == null)
        {
            imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return imageDescriptorRegistry;
    }
}