/*******************************************************************************
 * Copyright (c) 2003-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

/**
 * Represents the page being displayed in an IDialogPageContainer.
 * Implementations should extend DialogPage.
 * 
 * @author rcernich
 */
public interface IDialogPage extends org.eclipse.jface.dialogs.IDialogPage {

	/**
	 * This method is used by the container to manage the enablement of the
	 * apply and OK buttons on the dialog.
	 * 
	 * @return true if the contents of this page are valid.
	 */
	public boolean isValid();

	/**
	 * This method is used by the container to manage the enablement of the
	 * apply and OK buttons on the dialog.
	 * 
	 * @return true if the data managed by this page has changed.
	 */
	public boolean isModified();

	/**
	 * Called when the user presses the OK button.
	 * 
	 * @return true if successful 
	 */
	public boolean performOk();

	/**
	 * Called when the user presses the apply button.
	 * 
	 * @return true if successful 
	 */
	public boolean performApply();
	
	/**
	 * Called when the user presses the cancel button.
	 * 
	 * @return true if successful 
	 */
	public boolean performCancel();
	
	/**
	 * @return true if this dialog needs an apply button.
	 */
	public boolean needsApplyButton();
	/**
	 * @param needsApply true if this dailog should have an apply button.
	 */
	public void setNeedsApplyButton(boolean needsApply);

	/**
	 * @return the container managing this page
	 */
	public IDialogPageContainer getContainer();

	/**
	 * This method is used internally by the dialog framework and should not
	 * normally be called by page implementers.
	 * 
	 * @param container set the container managing this page
	 */
	public void setContainer(IDialogPageContainer container);

}
