/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.soas.internal.deploy.ui.ISharedGraphicConstants;
import org.eclipse.stp.soas.internal.deploy.ui.SharedImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/**
 * @author rcernich
 * 
 * Created on Mar 4, 2004
 */
public class FormOutlinePage extends ContentOutlinePage {

	private EnhancedFormEditor mEditor;
	private boolean mProcessingSetSelection = false;

	/**
	 *  
	 */
	public FormOutlinePage(EnhancedFormEditor editor) {
		super();
		mEditor = editor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.part.IPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		super.createControl(parent);
		getTreeViewer().setContentProvider(createContentProvider());
		getTreeViewer().setLabelProvider(createLabelProvider());
		getTreeViewer().setInput(mEditor);
		getTreeViewer().setAutoExpandLevel(AbstractTreeViewer.ALL_LEVELS);
		mEditor.getSite().getSelectionProvider().addSelectionChangedListener(
				this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ISelectionProvider#setSelection(org.eclipse.jface.viewers.ISelection)
	 */
	public void setSelection(ISelection selection) {
		if (!mProcessingSetSelection) {
			try {
				mProcessingSetSelection = true;
				super.setSelection(selection);
			}
			finally {
				mProcessingSetSelection = false;
			}
		}
	}

	public void selectionChanged(SelectionChangedEvent event) {
		// Don't handle this if it was spawned through our selection listener.
		if (!mProcessingSetSelection) {
			try {
				mProcessingSetSelection = true;
				if (event.getSelectionProvider() == getTreeViewer()) {
					IStructuredSelection selection = (IStructuredSelection) event
							.getSelection();
					updateEditor(selection);
					fireSelectionChanged(selection);
				}
				else {
					updateOutline((IStructuredSelection) event.getSelection());
				}
			}
			finally {
				mProcessingSetSelection = false;
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.part.IPage#dispose()
	 */
	public void dispose() {
		mEditor.getSite().getSelectionProvider()
				.removeSelectionChangedListener(this);
		super.dispose();
	}

	public EnhancedFormEditor getEditor() {
		return mEditor;
	}

	protected ITreeContentProvider createContentProvider() {
		return new FormContentProvider();
	}

	protected ILabelProvider createLabelProvider() {
		return new FormLabelProvider();
	}
	
	protected IFormPage getParentPage(IStructuredSelection selection) {
		IFormPage page;
		if (selection.isEmpty() || !(selection.getFirstElement() instanceof IFormPage)) {
			page = null;
		}
		else {
			page = (IFormPage)selection.getFirstElement();
		}
		return page;
	}

	protected void updateOutline(IStructuredSelection selection) {
		IFormPage activePage = mEditor.getActivePageInstance();
		getTreeViewer().setSelection(new StructuredSelection(activePage), true);
	}
	
	protected void updateEditor(IStructuredSelection selection) {
		IFormPage activePage = mEditor.getActivePageInstance();
		IFormPage selectionPage = getParentPage(selection);
		if (selectionPage != null) {
			if (activePage != selectionPage) {
				mEditor.setActivePage(selectionPage.getId());
			}
			if (selectionPage != null) {
				selectionPage.selectReveal(selection);
			}
		}
	}

	public class FormContentProvider implements ITreeContentProvider {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement) {
			Object[] children;
			if (parentElement instanceof EnhancedFormEditor) {
				children = ((EnhancedFormEditor) parentElement).getPages();
			}
			else {
				children = new Object[0];
			}
			return children;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
		 */
		public Object getParent(Object element) {
			Object parent;
			if (element instanceof IFormPage) {
				parent = ((IFormPage) element);
			}
			else {
				parent = null;
			}
			return parent;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
		 */
		public boolean hasChildren(Object element) {
			return getChildren(element).length > 0;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			return getChildren(inputElement);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
			// Empty
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
		 *      java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			// Empty
		}
	}

	public class FormLabelProvider extends LabelProvider {

		private Image mPageImage;

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
		 */
		public void dispose() {
			if (mPageImage != null) {
				mPageImage.dispose();
				mPageImage = null;
			}
			super.dispose();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
		 */
		public Image getImage(Object element) {
			Image image;
			if (element instanceof IFormPage) {
				image = getPageImage();
			}
			else {
				image = super.getImage(element);
			}
			return image;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
		 */
		public String getText(Object element) {
			String text;
			if (element instanceof IFormPage) {
				text = ((IFormPage) element).getTitle();
			}
			else {
				text = super.getText(element);
			}
			return text;
		}

		protected Image getPageImage() {
			if (mPageImage == null) {
				mPageImage = SharedImages.getImageDescriptor(
						ISharedGraphicConstants.IMG_PROPERTIES,
						SharedImages.SIZE_16).createImage();
			}
			return mPageImage;
		}
	}

}