/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.util.List;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;

/**
 * This interface is used for accessing functionality and information provided
 * by a deployDriver extension point implementation.
 * 
 * @author rcernich
 * 
 * Created on Jan 16, 2004
 */
public interface IDeployDriverExtension {

	/**
	 * @return the id of this deployment extension.
	 */
	String getID();

	/**
	 * @return the name of this deployment extension
	 */
	String getName();

	/**
	 * @return the connection profile type supported by this deployment driver
	 */
	IConnectionProfileProvider getConnectionProfileProvider();

	/**
	 * @return true if this driver creates transactional deploy sessions (i.e.
	 *         ITransactionalDeploySession objects).
	 */
	boolean isTransaction();

	/**
	 * @return the server type supported by this driver.
	 */
	ISupportedServerType getSupportedServerType();

	/**
	 * Uses the minimum version, maximum version, and match rule information
	 * associated with this extension to determine whether or not a server may
	 * supported by this driver.
	 * 
	 * @param type the type of server
	 * 
	 * @return true if this driver provides support for the specified server and
	 *         version.
	 */
	boolean supportsServer(IServerType type);

	/**
	 * Adapt the specified profile to a deploy target representation. If the
	 * profile cannot be adapted, null must be returned.
	 * 
	 * @param profile the profile to adapt.
	 * 
	 * @return an IDeployTarget representation of the profile.
	 */
	IDeployTarget adaptProfile(IConnectionProfile profile);

	/**
	 * @return a list containing all the package constructors contained by this
	 *         driver
	 */
	List getPackageConstructors();

	/**
	 * Returns a package constructor for the specified technology type.
	 * 
	 * @param type
	 * 
	 * @return a package constructor for the specified technology type; null if
	 *         no contructor exists for the specified type.
	 */
	IPackageConstructorExtension getPackageConstructor(ITechnologyType type);

}