/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;



/**
 * This interface is used for accessing functionality and information provided
 * by a logicalPackage extension point implementation.
 * 
 * @author rcernich
 *
 * Created on Mar 23, 2004
 */
public interface ILogicalPackageExtension extends IPackageExtension {
	
	ISupportedTechnologyType getSupportedTechnologyType();
	
	/**
	 * Returns true if this extension is capable of producing extensions of
	 * the specified technology type and version.
	 * 
	 * @param type the type of technology
	 * 
	 * @return true if this extension is capable of producing packages of the
	 * specified technology and version.
	 */
	boolean supportsTechnology(ITechnologyType type);
	
}
