/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;


/**
 * @author rcernich
 *
 * Created on Apr 8, 2004
 */
public interface ISupportedTechnologyType {

	/**
	 * Returns the technology type of the packages produced by this extension.
	 * This information is used by the deployment framework for linking logical
	 * package, physical package and deployment extensions together.
	 * 
	 * @return the technology type of the packages produced by this extension.
	 */
	ITechnologyDefinition getTechnologyDefinition();
	
	/**
	 * Returns the minimum supported version of the technology that packages
	 * produced by this extension may be deployed to.
	 * 
	 * @return the minimum supported technology version.
	 */
	IVersion getMinVersion();
	
	/**
	 * Returns the maximum supported version of the technology that packages
	 * produced by this extension may be deployed to.
	 * 
	 * @return the maximum supported technology version.
	 */
	IVersion getMaxVersion();
	
	boolean supportsTechnology(ITechnologyType type);
	
}
