/*******************************************************************************
 * Copyright (c) 2003-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

/**
 * This interface wraps requests for version information that may be associated
 * with certain objects.  The version is identified as follows,
 * major.minor.release.build.
 * 
 * XXX: Replace this with org.eclipse.osgi.service.resolver.Version
 * 
 * @author rcernich
 *
 * Created on Nov 13, 2003
 */
public interface IVersion extends Comparable {

	/**
	 * @return the major component of this version
	 */
	int getMajor();

	/**
	 * @return the minor component of this version
	 */
	int getMinor();

	/**
	 * @return the release of this version
	 */
	int getRelease();

	/**
	 * @return the build of this version
	 */
	String getBuild();
	
	/**
	 * Compares this version with the target version using the specified match
	 * rule as follows:
	 * 		PERFERCT	==> This version exactly matches the actual version
	 * 		EQUIVALENT	==> The major and minor fields of this version match those of the actual version and the release and build fields of the actual version are greater than or equal to this version's.
	 * 		COMPATIBLE	==> The major field of this version match those of the actual version and the minor, release and build fields of the actual version are greater than or equal to this version's.
	 * 		EQUAL_OR_GREATER	==> This actual version is newer than this version
	 * 
	 * @param actual
	 * @param matchRule
	 * 
	 * @return true if the versions are equivalent based on the rule being used.
	 */
	boolean isCompatibleWithVersion(IVersion actual,MatchRule matchRule);

	/**
	 * @param o
	 * @return getMajor().equals(o.getMajor()) && getMinor().equals(o.getMinor()) && getRelease().equals(o.getRelease()) && getBuild().equals(o.getBuild())
	 */
	boolean equals(Object o);
	
	/**
	 * @return an appropriate hash code
	 */
	int hashCode();

}
