/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.resources.IFile;


/**
 * @author rcernich
 *
 * Created on Apr 8, 2004
 */
public abstract class PackageBase implements IPackage {

	private IFile mFile;
	private IPackageExtension mExtension;

	public PackageBase() {
		super();
	}

	public void init(IPackageExtension extension, IFile pkg) {
		mFile = pkg;
		mExtension = extension;
	}

	public IFile getFile() {
		return mFile;
	}

	public String getName() {
		return getFile().getName();
	}

	public IPackageExtension getExtension() {
		return mExtension;
	}
	
}
