/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author rcernich
 * 
 * Created on Jul 20, 2004
 */
public abstract class PackageOutputDescriptor implements
		IPackageOutputDescriptor {

	private ITechnologyType mTechnologyType;
	private IServerType mServerType;
	private String mFileName;
	private String mLogicalName;

	public PackageOutputDescriptor(ITechnologyType technologyType,
									IServerType serverType, String fileName,
									String logicalName) {
		super();
		mTechnologyType = technologyType;
		mServerType = serverType;
		mFileName = fileName;
		mLogicalName = logicalName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor#getTechnologyType()
	 */
	public ITechnologyType getTechnologyType() {
		return mTechnologyType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor#getServerType()
	 */
	public IServerType getServerType() {
		return mServerType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor#getFileName()
	 */
	public String getFileName() {
		return mFileName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor#getLogicalName()
	 */
	public String getLogicalName() {
		return mLogicalName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor#createInputStream()
	 */
	public abstract InputStream createInputStream() throws IOException;

}