/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.adapters;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;

/**
 * @author rcernich
 * 
 * Created on Jul 16, 2004
 */
public class DeployConfigurationDeployAPIAdapter extends AdapterImpl implements
		IDeployAPIAdapter {

	public DeployConfigurationDeployAPIAdapter() {
		super();
	}

	public boolean isAdapterForType(Object type) {
		return type == IDeployAPIAdapter.class;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asDeployTarget()
	 */
	public IDeployTarget asDeployTarget() {
		IDeployTarget idt = null;
		IPackage ip = asPackage();
		IConnectionProfile profile = asConnectionProfile();
		IDeployDriverExtension idde = DeploymentExtensionManager.getInstance()
				.getDeployDriver(ip, profile.getProviderId());
		if (idde != null) {
			idt = idde.adaptProfile(profile);
		}
		return idt;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asLogicalPackage()
	 */
	public ILogicalPackage asLogicalPackage() {
		ILogicalPackage ilp;
		IFile file = getFile();
		if (file == null) {
			ilp = null;
		}
		else {
			ilp = DeploymentExtensionManager.getInstance().getLogicalPackage(
					file);
		}
		return ilp;
	}

	public IConfigurablePackage asConfigurablePackage() {
		IConfigurablePackage icp;
		IFile file = getFile();
		if (file == null) {
			icp = null;
		}
		else {
			icp = DeploymentExtensionManager.getInstance()
					.getConfigurablePackage(file);
		}
		return icp;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asPackage()
	 */
	public IPackage asPackage() {
		IPackage ip;
		IFile file = getFile();
		if (file == null) {
			ip = null;
		}
		else {
			ip = DeploymentExtensionManager.getInstance().getPackage(file);
			if (ip instanceof IPhysicalPackage) {
				// The manager may not return the correct type for the server
				ip = asPhysicalPackage();
			}
		}
		return ip;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asPhysicalPackage()
	 */
	public IPhysicalPackage asPhysicalPackage() {
		IPhysicalPackage ipp;
		IFile file = getFile();
		if (file == null) {
			ipp = null;
		}
		else {
			ipp = DeploymentExtensionManager.getInstance().getPhysicalPackage(
					file);
			List packageExtensions = DeploymentExtensionManager.getInstance()
					.getPhysicalPackageExtensions(file.getFileExtension());
			if (ipp != null && packageExtensions.size() > 1) {
				// Make sure we got the correct type
				IConnectionProfile profile = asConnectionProfile();
				if (profile != null) {
					String profileProviderID = profile.getProviderId();
					if (DeploymentExtensionManager.getInstance()
							.getDeployDriver(ipp, profileProviderID) == null) {
						// Need to find the correct extension for this config
						ipp = null;
						for (Iterator it = packageExtensions.iterator(); ipp == null
								&& it.hasNext();) {
							IPhysicalPackageExtension ippe = (IPhysicalPackageExtension) it
									.next();
							IPhysicalPackage tmpIpp = (IPhysicalPackage) ippe
									.adaptFile(file);
							if (DeploymentExtensionManager.getInstance()
									.getDeployDriver(tmpIpp, profileProviderID) != null) {
								ipp = tmpIpp;
							}
						}
					}
				}
			}
		}
		return ipp;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asConnectionProfile()
	 */
	public IConnectionProfile asConnectionProfile() {
		DeployServer server = ((DeployConfiguration) getTarget())
				.getTargetServer();
		if (server == null) {
			return null;
		}
		return ProfileManager.getInstance().getProfileByName(
				server.getProfileName());
	}

	private IFile getFile() {
		try {
			IFile retVal;
			DeployPackage dp = ((DeployConfiguration) getTarget())
					.getSourcePackage();
			String path = dp.getPackageFile();
			URL url = FileLocator.toFileURL(new URL(dp.eResource().getURI()
					.toString()));
			IFile deployFile = DeployCorePlugin.getWorkspace().getRoot()
					.getFileForLocation(new Path(url.getPath()));
			IProject project = deployFile.getProject();
			retVal = project.getFile(path);
			for (Iterator it = Arrays.asList(project.getReferencedProjects()).iterator(); !retVal.exists() && it.hasNext(); ) {
				project = (IProject) it.next();
				retVal = project.getFile(path);
			}
			
			if (retVal.exists()) {
				return retVal;
			}
		}
		catch (CoreException e) {
		}
		catch (MalformedURLException e) {
		}
		catch (IOException e) {
		}
		return null;
	}

}