/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.actions;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.internal.deploy.ui.CreatePackageControl;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * @author brandow
 */
public class PackageConstructorDialog extends TitleAreaDialog
{
    private ListViewer                      _packageConstructorList;
    private ILogicalPackage                 _package;
    private IPackageConstructorExtension    _selectedPackageConstructor;

    /**
     * Constructor
     * 
     * @param parentShell
     */
    public PackageConstructorDialog(Shell parentShell, ILogicalPackage pkg)
    {
        super(parentShell);
        setShellStyle(getShellStyle() | SWT.RESIZE);
        _package = pkg;
        _selectedPackageConstructor = null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
     */
    protected void configureShell(Shell shell)
    {
        super.configureShell(shell);
        shell.setText(DeployCorePlugin.getDefault().getResourceString("PackageConstructorDialog.shell.text")); //$NON-NLS-1$
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    protected Control createDialogArea(Composite parent)
    {
        Composite content = (Composite) super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        content.setLayout(gl);

        _packageConstructorList = new ListViewer(content, SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
        GridData partListData = new GridData(GridData.GRAB_HORIZONTAL | GridData.HORIZONTAL_ALIGN_FILL
                                           | GridData.GRAB_VERTICAL | GridData.VERTICAL_ALIGN_FILL);
        _packageConstructorList.getList().setLayoutData(partListData);
        _packageConstructorList.getList().setFont(parent.getFont());
        _packageConstructorList.setContentProvider(new CreatePackageControl.PackageConstructorContentProvider());
        _packageConstructorList.setLabelProvider(new CreatePackageControl.PackageConstructorLabelProvider());
        _packageConstructorList.addFilter(new CreatePackageControl.TechnologyTypeFilter(_package));
        _packageConstructorList.setInput(DeploymentExtensionManager.getInstance());
         _packageConstructorList.addSelectionChangedListener(new ISelectionChangedListener()
        {
         	public void selectionChanged(SelectionChangedEvent event)
            {
         		Button ok = getButton(IDialogConstants.OK_ID);
         		if (ok != null) {
	                if (((IStructuredSelection)_packageConstructorList.getSelection()).size() > 0)
	                {
	                    ok.setEnabled(true);
	                }
	                else
	                {
	                    ok.setEnabled(false);
	                }
         		}
                updateSelectedPackageConstructorNames();
            }
        });
        
        setTitle(DeployCorePlugin.getDefault().getResourceString("PackageConstructorDialog.title")); //$NON-NLS-1$
        setMessage(DeployCorePlugin.getDefault().getResourceString("PackageConstructorDialog.message")); //$NON-NLS-1$

        if (_packageConstructorList.getList().getItemCount() > 0)
        {
            _packageConstructorList.setSelection(new StructuredSelection(_packageConstructorList.getElementAt(0)));
        }
        
        return content;
    }

    protected Control createContents(Composite parent)
    {
        Control         contents = super.createContents(parent);
        
        getButton(IDialogConstants.OK_ID).setEnabled(_packageConstructorList.getList().getItemCount() > 0);
        return contents;
    }
    
    /**
     * Returns the selected package constructor name
     */
    public IPackageConstructorExtension getSelectedPackageConstructor()
    {
        return _selectedPackageConstructor;
    }
    
    private void updateSelectedPackageConstructorNames()
    {
        IStructuredSelection      selection = (IStructuredSelection)_packageConstructorList.getSelection();

        if (selection.size() == 0)
        {
            _selectedPackageConstructor = null;
        }
        else
        {
            _selectedPackageConstructor = (IPackageConstructorExtension)selection.getFirstElement();
        }
    }
}