/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.cheetsheets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

/**
* A base class for Deployment Definition editor
* cheatsheet actions.  Locates the appropriate editor.
*
* @author Jane Cantz
*/
public class InvokeEditorActions extends Action implements ICheatSheetAction
{
	public InvokeEditorActions()
	{
		super();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.cheatsheets.ICheatSheetAction#run(java.lang.String[], org.eclipse.ui.cheatsheets.ICheatSheetManager)
	 */
	public void run(String[] params, ICheatSheetManager manager)
	{
		super.run();
	}
	
	/**
	 * @return Returns the services package editor, if any open.
	 */
	public DeployEditor getDeployEditor()
	{
		IEditorPart editor = null;
	
		// Find the editor we are interested in
		editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
		if (editor != null)
		{
			if (editor instanceof DeployEditor)
			{
				//  found the editor
				return (DeployEditor)editor;
			}
			else
			{
				//  Look for any open editors
				IEditorReference[] editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
				for (int e=0; e < editors.length; e++)
				{
					if (editors[e] instanceof DeployEditor)
					{
						editor = editors[e].getEditor(true);
						PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(editor);
						return (DeployEditor)editor;
					}
				}
			}
		}
		return null;
	}
	
	protected boolean reportWrongEditor()
	{
		MessageDialog.openInformation(new Shell(),
			DeployCorePlugin.getDefault().getResourceString("Cheatsheets.Error.Title"), //$NON-NLS-1$
			DeployCorePlugin.getDefault().getResourceString("Cheatsheets.Error.WrongEditor")); //$NON-NLS-1$
		return false;
	}
}
