/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.cheetsheets;

import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditor;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.forms.editor.IFormPage;

/**
 * Cheatsheet action to select a page in the
 * Deployment Definition Editor
 * 
 * @author Jane Cantz
 */
public class OpenDeployEditorPageAction extends InvokeEditorActions
{
	/* 
	 * Valid params1:
	 * "DeployDefinitionEditor.page.introduction"
	 * "DeployDefinitionEditor.page.overview"
	 * "DeployDefinitionEditor.page.configuration"
	 * "DeployDefinitionEditor.page.summary"
	 * 
	 * @see org.eclipse.ui.cheatsheets.ICheatSheetAction#run(java.lang.String[], org.eclipse.ui.cheatsheets.ICheatSheetManager)
	 */
	public void run(String[] params, ICheatSheetManager manager)
	{
		DeployEditor deployEditor = getDeployEditor();
		if (deployEditor != null)
		{
			IFormPage page = deployEditor.findPage(params[0]);
			if (page != null)
			{
				deployEditor.setActivePage(params[0]);
				notifyResult(true);
				return;
			}
		}

		//  Deploy Editor is not open
		notifyResult(reportWrongEditor());
	}
}
