/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.cheetsheets;

import java.util.Iterator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.DeployFileNewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

/**
* The cheat sheet action that
* invokes the new Deployment Definition wizard
*
* @author Jane Cantz
*/
public class OpenDeployWizardAction extends Action implements ICheatSheetAction
{
	/**  The Eclipse Navigator View  */
	private static String RESOURCE_NAV_ID = "org.eclipse.ui.views.ResourceNavigator"; //$NON-NLS-1$
	
	public OpenDeployWizardAction()
	{
		super();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.cheatsheets.ICheatSheetAction#run(java.lang.String[], org.eclipse.ui.cheatsheets.ICheatSheetManager)
	 */
	public void run(String[] params, ICheatSheetManager manager)
	{
		IProject selProject = null;
	
		//  Find the project for the current selection
		IWorkbenchWindow [] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
		for (int w =0; w < windows.length && selProject == null; w++)
		{
			IWorkbenchPage[] pages = windows[w].getPages();
			for (int p =0; p < pages.length; p++)
			{
				IWorkbenchPage page = pages[p];
				IViewReference[] views = page.getViewReferences();
				for (int v =0; v < views.length && selProject == null; v++)
				{
					String id = views[v].getId();
					if (id.equals(RESOURCE_NAV_ID))
					{
						IStructuredSelection selection = (IStructuredSelection)views[v].getPart(false).getSite().getSelectionProvider().getSelection();
						if (selection.isEmpty())
						{
							// continue
						}
						else
						{
							for (Iterator it = selection.iterator(); it.hasNext();)
							{
								Object o = it.next();
								if (o instanceof IResource)
								{
									selProject = ((IResource)o).getProject();
									break;
								}
							}
						}
					}
				}
			}
		}
	
		// Create the wizard
		DeployFileNewWizard wizard = new DeployFileNewWizard();
		IStructuredSelection sel = new StructuredSelection(selProject);
		wizard.init(PlatformUI.getWorkbench(), sel);
	
		// Create the wizard dialog
		WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),wizard);
	
		// Open the wizard dialog
		dialog.open();
	}
}
