/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.configuration;

import java.util.Iterator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConfigurationManager;
import org.eclipse.swt.widgets.Shell;


/**
 * @author rcernich
 * 
 * Created on Dec 2, 2004
 */
public class ConfigurationDialog extends PreferenceDialog {

	private IPackageConfiguration mPackageConfiguration;
	private IPackageConfigurationManager mPackageConfigManager;

	/**
	 * @param parentShell
	 * @param manager
	 */
	public ConfigurationDialog(Shell parentShell,
								IPackageConfiguration packageConfiguration) {
		super(parentShell, new PreferenceManager());
		mPackageConfiguration = packageConfiguration;
		mPackageConfigManager = ((IConfigurablePackageExtension) mPackageConfiguration
				.getPackage().getExtension()).getPackageConfigurationManager();

		if (mPackageConfiguration == null) {
			mPackageConfiguration = mPackageConfigManager
					.createPackageConfiguration(packageConfiguration.getPackage());
		}

		mPackageConfigManager.getConfigurationPageFactory().contribute(
				getPreferenceManager(), mPackageConfiguration);
	}

	public IPackageConfiguration getPackageConfiguration() {
		return mPackageConfiguration;
	}

	protected void handleSave() {
		super.handleSave();
		for (Iterator it = getPreferenceManager().getElements(
				PreferenceManager.PRE_ORDER).iterator(); it.hasNext();) {
			IConfigurationNode node = (IConfigurationNode) it.next();
			if (node != null && node.needsSave()) {
				try {
					node.save();
				}
				catch (CoreException e) {
					e.printStackTrace();
				}
			}
		}
	}
}