/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.ui.configuration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.ui.dialogs.PropertyPage;


/**
 * @author rcernich
 * 
 * Created on Dec 2, 2004
 */
public abstract class ConfigurationNode extends PreferenceNode implements
		IConfigurationNode {

	private IPackageConfiguration mConfiguration;

	/**
	 * Constructor for ConfigurationNode.
	 * 
	 * @param id
	 * @param preferencePage
	 */
	public ConfigurationNode(String id, String label,
								ImageDescriptor imageDesc,
								IPackageConfiguration configuration) {
		super(id, label, imageDesc, null);
		mConfiguration = configuration;
	}

	/**
	 * @see org.eclipse.jface.preference.IPreferenceNode#createPage()
	 */
	public final void createPage() {
		PropertyPage ppage = createPropertyPage();
		ppage.setElement(mConfiguration);
		ppage.setTitle(getLabelText());
		setPage(ppage);
	}

	protected abstract PropertyPage createPropertyPage();

	public IPackageConfiguration getConfiguration() {
		return mConfiguration;
	}

	public void setConfiguration(IPackageConfiguration configuration) {
		mConfiguration = configuration;

	}

	/**
	 * @see com.nnsy.ebd.eai.demo.configadmin.properties.IConfigurationNode#saveProperties()
	 */
	public void save() throws CoreException {
	}

	/**
	 * @see com.nnsy.ebd.eai.demo.configadmin.properties.IConfigurationNode#needsSave()
	 */
	public boolean needsSave() {
		return false;
	}

}