/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.IDeploySession;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IServerType;


/**
 * @author rcernich
 *
 * Created on Jul 21, 2004
 */
public class DeployTarget implements IDeployTarget {

	private DeployDriverExtension mDeployDriver;
	private IConnectionProfile mProfile;
	
	public DeployTarget(DeployDriverExtension deployDriver,IConnectionProfile profile) {
		super();
		mDeployDriver = deployDriver;
		mProfile = profile;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeployTarget#createDeploySession()
	 */
	public IDeploySession createDeploySession() {
		return mDeployDriver.createDeploySession(mProfile);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeployTarget#supportsServer(org.eclipse.stp.soas.deploy.core.IServerType)
	 */
	public boolean supportsServer(IServerType serverType) {
		return mDeployDriver.supportsServer(serverType);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeployTarget#getDeployDriver()
	 */
	public IDeployDriverExtension getDeployDriver() {
		return mDeployDriver;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.IDeployTarget#getConnectionProfile()
	 */
	public IConnectionProfile getConnectionProfile() {
		return mProfile;
	}

}
