/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Version;

/**
 * @author rcernich
 * 
 * Created on Apr 8, 2004
 */
public class TechnologyType implements ITechnologyType {

	private String mTechnologyDef;
	private Version mVersion;

	public TechnologyType(String technologyDef, Version version) {
		super();
		if (DeploymentExtensionManager.getInstance().getTechnologyDefinition(
				technologyDef) == null) {
			throw new IllegalArgumentException(
					DeployCorePlugin
							.getDefault()
							.getResourceString(
									"TechnologyType.exception.technologyDefinitionDoesNotExist", //$NON-NLS-1$
									new Object[] { technologyDef}));
		}
		mTechnologyDef = technologyDef;
		mVersion = version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ITechnologyType#getTechnologyDefinition()
	 */
	public ITechnologyDefinition getTechnologyDefinition() {
		return DeploymentExtensionManager.getInstance()
				.getTechnologyDefinition(mTechnologyDef);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.ITechnologyType#getVersion()
	 */
	public IVersion getVersion() {
		return mVersion;
	}

	public String toString() {
		return DeployCorePlugin
				.getDefault()
				.getResourceString(
						"TechnologyType.toString", new Object[] { mTechnologyDef, mVersion}); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		boolean retVal;
		if (this == obj) {
			retVal = true;
		}
		else if (obj instanceof TechnologyType) {
			TechnologyType tt = (TechnologyType) obj;
			retVal = mTechnologyDef.equals(tt.mTechnologyDef)
					&& mVersion.equals(tt.mVersion);
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		// Could do better, but this should work.
		return mTechnologyDef.hashCode();
	}
}