/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui;

import org.eclipse.datatools.connectivity.ui.dse.views.ConnectionProfileContentProvider;
import org.eclipse.datatools.connectivity.ui.dse.views.ConnectionProfileLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;

/**
 * @author rcernich
 * 
 * Created on Jan 23, 2004
 */
public class ConnectionProfileTreeViewer {

	private TreeViewer mProfiles;

	public ConnectionProfileTreeViewer(Tree tree) {
		super();
		createControl(tree);
	}

	public TreeViewer getViewer() {
		return mProfiles;
	}

	private void createControl(Tree tree) {
		mProfiles = new TreeViewer(tree);
		mProfiles.setContentProvider(new ConnectionProfileContentProvider());
		mProfiles.setLabelProvider(new ConnectionProfileLabelProvider());
	}

}
