/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IDeployDriverExtension;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.ui.actions.CreatePackageFileAction;
import org.eclipse.stp.soas.internal.deploy.ui.viewers.DropListViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * @author rcernich
 * 
 * Created on Nov 4, 2004
 */
public class CreatePackageControl {

	public static final String LABEL_SERVER_TYPE = DeployCorePlugin
			.getDefault().getResourceString("LABEL_SERVER_TYPE"); //$NON-NLS-1$
	public static final String BUTTON_CREATE_PACKAGE = DeployCorePlugin
			.getDefault().getResourceString("BUTTON_CREATE_PACKAGE"); //$NON-NLS-1$

	private Composite mControl;
	private DropListViewer mPackageConstructors;
	private Button mCreatePackageButton;
	private TechnologyTypeFilter mConstructorFilter;
	private ILogicalPackage mPackage;
	private boolean mEnabled = true;

	public CreatePackageControl() {
		super();
		mConstructorFilter = new TechnologyTypeFilter(null);
	}

	public void createControl(Composite parent, FormToolkit toolkit) {
		mControl = toolkit.createComposite(parent);
		mControl.setLayout(new GridLayout(3, false));

		Label label = toolkit.createLabel(mControl, LABEL_SERVER_TYPE);
		label.setLayoutData(new GridData());

		mPackageConstructors = new DropListViewer(mControl);
		mPackageConstructors
				.setLabelProvider(new PackageConstructorLabelProvider());
		mPackageConstructors
				.setContentProvider(new PackageConstructorContentProvider());
		mPackageConstructors
				.addSelectionChangedListener(new ISelectionChangedListener() {

					public void selectionChanged(SelectionChangedEvent event) {
						handlePackageConstructorChanged();
					}
				});
		mPackageConstructors.addFilter(mConstructorFilter);
		mPackageConstructors.setInput(DeploymentExtensionManager.getInstance());
		mCreatePackageButton = toolkit.createButton(mControl,
				BUTTON_CREATE_PACKAGE, SWT.PUSH);
		mCreatePackageButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent event) {
				createPackage();
			}
		});
	}

	public IPackageConstructorExtension getSelection() {
		IPackageConstructorExtension retVal;
		IStructuredSelection selection = (IStructuredSelection) mPackageConstructors
				.getSelection();
		if (selection.isEmpty()) {
			retVal = null;
		}
		else {
			retVal = (IPackageConstructorExtension) selection.getFirstElement();
		}
		return retVal;
	}

	public void setSelection(IPackageConstructorExtension selection) {
		if (selection == null) {
			mPackageConstructors.setSelection(StructuredSelection.EMPTY);
		}
		else {
			mPackageConstructors.setSelection(
					new StructuredSelection(selection), true);
		}
	}

	public void setInputFile(IFile file) {
		mPackage = DeploymentExtensionManager.getInstance().getLogicalPackage(
				file);
		mConstructorFilter.setPackage(mPackage);
		mPackageConstructors.refresh();

		if (mPackageConstructors.getCombo().getItemCount() > 0) {
			Combo combo = mPackageConstructors.getCombo();
			combo.setText(combo.getItem(0));
		}

		updateControls();
	}

	public boolean getEnabled() {
		return mCreatePackageButton.getEnabled();
	}

	public void setEnabled(boolean enabled) {
		mEnabled = enabled;
		updateControls();
	}

	public Control getControl() {
		return mControl;
	}

	public void createPackage() {
		new CreatePackageFileAction(new String(),
				mPackage, getSelection()).run();
	}

	private void handlePackageConstructorChanged() {
		updateControls();
	}

	private void updateControls() {
		if (mCreatePackageButton == null) {
			return;
		}
		mCreatePackageButton
				.setEnabled(mEnabled
						&& !((IStructuredSelection) mPackageConstructors
								.getSelection()).isEmpty());
	}

	public static class PackageConstructorContentProvider implements
			IStructuredContentProvider {

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

		public Object[] getElements(Object inputElement) {
			DeploymentExtensionManager dem = (DeploymentExtensionManager) inputElement;
			ArrayList constructors = new ArrayList();
			for (Iterator it = dem.getDeployDrivers().iterator(); it.hasNext();) {
				IDeployDriverExtension driver = (IDeployDriverExtension) it
						.next();
				constructors.addAll(driver.getPackageConstructors());
			}
			return constructors.toArray();
		}

		public void dispose() {
		}
	}

	public static class PackageConstructorLabelProvider extends LabelProvider {

		public String getText(Object element) {
			IDeployDriverExtension driver = ((IPackageConstructorExtension) element)
					.getDeployDriver();
			String retVal = driver.getName();
			if (retVal == null) {
				retVal = driver.getID();
				String profileType = driver.getConnectionProfileProvider()
						.getName();
				if (profileType != null && profileType.length() > 0) {
					retVal = retVal + " (" + profileType + ")"; //$NON-NLS-1$ //$NON-NLS-2$
				}
			}
			return retVal;
		}
	}

	public static class TechnologyTypeFilter extends ViewerFilter {

		private ILogicalPackage mPackage;

		public TechnologyTypeFilter(ILogicalPackage pkg) {
			super();
			setPackage(pkg);
		}

		public void setPackage(ILogicalPackage pkg) {
			mPackage = pkg;
		}

		public boolean select(Viewer viewer, Object parentElement,
				Object element) {
			return mPackage == null
					|| ((IPackageConstructorExtension) element)
							.supportsPackage(mPackage);
		}
	}

}