/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.ProfileImageRegistry;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.internal.deploy.emf.AdapterFactoryContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/**
 * @author rcernich
 * 
 * Created on Jan 23, 2004
 */
public class TargetMapTreeViewer {

	public static final String LABEL_UNSPECIFIED_TARGET = DeployCorePlugin
			.getDefault().getResourceString("LABEL.unspecifiedTarget"); //$NON-NLS-1$

	private TreeViewer mPackages;

	public TargetMapTreeViewer(Tree tree) {
		super();
		createControl(tree);
	}

	public TreeViewer getViewer() {
		return mPackages;
	}

	private void createControl(Tree tree) {
		mPackages = new TreeViewer(tree);
		mPackages.setContentProvider(new AdapterFactoryContentProvider(
				Utilities.getItemAdapterFactory()));
		mPackages.setLabelProvider(new TargetMapLabelProvider(Utilities
				.getItemAdapterFactory()));
		mPackages.addFilter(new ViewerFilter() {

			public boolean select(Viewer viewer, Object parentElement,
					Object element) {
				return element instanceof DeployPackage
						|| element instanceof DeployConfiguration;
			}
		});
	}

	private static class TargetMapLabelProvider extends
			AdapterFactoryLabelProvider {

		private ILabelProvider mWorkbenchLabelProvider = new WorkbenchLabelProvider();

		/**
		 * @param adapterFactory
		 */
		public TargetMapLabelProvider(AdapterFactory adapterFactory) {
			super(adapterFactory);
		}

		public Image getImage(Object element) {
			Image image = null;

			// make sure we get an adapter on this guy
			adapterFactory.adapt(element, IItemLabelProvider.class);
			if (element instanceof DeployPackage) {
				IPackage ip = Utilities
						.adaptToIPackage((DeployPackage) element);
				if (ip == null) {
					image = super.getImage(element);
				}
				else {
					image = mWorkbenchLabelProvider.getImage(ip.getFile());
				}
			}
			else if (element instanceof DeployConfiguration) {
				DeployConfiguration config = (DeployConfiguration) element;
				IConnectionProfile cp = Utilities
						.adaptToIConnectionProfile(config);
				if (cp == null) {
					image = super.getImage(config.getTargetServer());
				}
				else {
					image = ProfileImageRegistry.getInstance().getProfileImage(cp.getProvider());
				}
			}
			return image;
		}

		public String getText(Object element) {
			String text;

			// make sure we get an adapter on this guy
			adapterFactory.adapt(element, IItemLabelProvider.class);
			if (element instanceof DeployPackage) {
				IPackage ip = Utilities
						.adaptToIPackage((DeployPackage) element);
				if (ip == null) {
					text = super.getText(element);
				}
				else {
					text = ip.getFile().getFullPath().toString();
				}
			}
			else if (element instanceof DeployConfiguration) {
				DeployConfiguration config = (DeployConfiguration) element;
				IConnectionProfile cp = Utilities
						.adaptToIConnectionProfile(config);
				if (cp == null) {
					if (config.getTargetServer() == null
							|| config.getTargetServer().getProfileName() == null) {
						text = LABEL_UNSPECIFIED_TARGET;
					}
					else {
						text = config.getTargetServer().getProfileName();
					}
				}
				else {
					text = cp.getName();
				}
			}
			else {
				text = super.getText(element);
			}
			return text;
		}

		public void dispose() {
			mWorkbenchLabelProvider.dispose();
			super.dispose();
		}
	}

}