/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;


/**
 * @author rcernich
 * 
 * Created on May 11, 2005
 */
public class DeployStatusDialogPage extends BaseDeployStatusDialogPage {

	private int mSeverity = 0;

	public DeployStatusDialogPage(Map problemsMap) {
		super(DeployCorePlugin.getDefault().getResourceString(
				"DeployStatusDialog.TITLE"), problemsMap, true); //$NON-NLS-1$
		for (Iterator it = problemsMap.values().iterator(); (mSeverity & IStatus.ERROR) == 0
				&& it.hasNext();) {
			IStatus[] statuses = (IStatus[]) it.next();
			for (int index = 0, count = statuses.length; (mSeverity & IStatus.ERROR) == 0
					&& index < count; ++index) {
				mSeverity |= statuses[index].getSeverity();
			}
		}
	}

	protected void setStatusMessage() {
		if ((mSeverity & IStatus.ERROR) == 0) {
			setMessage(DeployCorePlugin.getDefault().getResourceString(
					"DeployStatusDialog.MESSAGE.Success")); //$NON-NLS-1$
		}
		else {
			setMessage(DeployCorePlugin.getDefault().getResourceString(
					"DeployStatusDialog.MESSAGE.Error"), ERROR); //$NON-NLS-1$
		}
	}

}