/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.operations.CreateDeployPackagesJob;
import org.eclipse.stp.soas.deploy.core.ui.actions.ExecuteDeployAction;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/**
 * @author rcernich
 * 
 * Created on Jan 21, 2004
 */
public class ConfigurationPage extends EMFFormPage {

	public static final String PAGE_TITLE = DeployCorePlugin.getDefault()
			.getResourceString("DeployDefinitionEditor.PGTITLE.Configuration"); //$NON-NLS-1$

	private TargetMapSection mConfiguration;
	private PackageDescriptionSection mDescription;
	private ServersSection mServers;
	private Button mCreatePackagesButton;
	private Button mDeployButton;
	private ExecuteDeployAction mDeployAction;

	/**
	 * @param editor
	 * @param title
	 */
	public ConfigurationPage(EMFFormEditor editor, String id, String title) {
		super(editor, id, title);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.FormPage#createFormContent(org.eclipse.ui.forms.IManagedForm)
	 */
	protected void createFormContent(IManagedForm managedForm) {
		super.createFormContent(managedForm);

		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();

		form.setText(PAGE_TITLE);

		GridLayout layout = EnhancedFormEditor.newPageGridLayout();
		layout.numColumns = 2;
		layout.makeColumnsEqualWidth = false;
		form.getBody().setLayout(layout);

		createDeployButtons(managedForm);

		mConfiguration = new TargetMapSection(form.getBody(), toolkit,
				Section.DESCRIPTION | ExpandableComposite.TITLE_BAR);
		mConfiguration.createClient(toolkit);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 2;
		mConfiguration.getSection().setLayoutData(gd);
		managedForm.addPart(mConfiguration);

		mDescription = new PackageDescriptionSection(form.getBody(), toolkit,
				Section.DESCRIPTION | Section.TWISTIE
						| ExpandableComposite.TITLE_BAR);
		mDescription.getSection().setExpanded(true);
		mDescription.createClient(toolkit);
		gd = new GridData(GridData.FILL_BOTH);
		mDescription.getSection().setLayoutData(gd);
		managedForm.addPart(mDescription);

		mServers = new ServersSection(form.getBody(), toolkit,
				Section.DESCRIPTION | Section.TWISTIE
						| ExpandableComposite.TITLE_BAR);
		mServers.getSection().setExpanded(true);
		mServers.createClient(toolkit);
		gd = new GridData(GridData.FILL_BOTH);
		mServers.getSection().setLayoutData(gd);
		managedForm.addPart(mServers);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(form,
				IHelpConstants.CONTEXT_ID_CONFIGURATION_PAGE);
	}

	private void createDeployButtons(IManagedForm managedForm) {
		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();

		Composite buttons = toolkit.createComposite(form.getBody());
		buttons.setLayout(new GridLayout(2, false));
		GridData gd = new GridData();
		gd.horizontalSpan = 2;
		buttons.setLayoutData(gd);

		mCreatePackagesButton = toolkit.createButton(buttons,
				DeployCorePlugin.getDefault().getResourceString(
						"ConfigurationPage.BUTTON.createPackages"), SWT.PUSH); //$NON-NLS-1$
		mCreatePackagesButton.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING));
		mCreatePackagesButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				handleCreatePackages();
			}
		});

		mDeployButton = toolkit.createButton(buttons, DeployCorePlugin
				.getDefault().getResourceString(
						"ConfigurationPage.BUTTON.deployPackages"), //$NON-NLS-1$
				SWT.PUSH);
		mDeployButton.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING));
		mDeployButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				handleDeploy();
			}
		});
		mDeployAction = new ExecuteDeployAction(DeployCorePlugin
				.getDefault().getResourceString(
						"ConfigurationPage.action.deployPackages"), form //$NON-NLS-1$
				.getShell());
		mDeployAction.selectionChanged(new StructuredSelection(
				getEMFFormEditor().getModelRoot()));
	}

	private void handleDeploy() {
		mDeployAction.run();
	}

	private void handleCreatePackages() {
		// Make sure any dirty files are saved.
		if (!DeployCorePlugin.getDefault().getWorkbench()
				.saveAllEditors(true)) {
			return;
		}
		
		final CreateDeployPackagesJob createPackages = new CreateDeployPackagesJob(
				(Root) getEMFFormEditor().getModelRoot());
		createPackages.addJobChangeListener(new JobChangeAdapter() {

			public void done(IJobChangeEvent event) {
				handleFinish(createPackages, event.getResult());
			}
		});
		
		createPackages.schedule();
	}

	private void handleFinish(CreateDeployPackagesJob createPackages,
		IStatus status) {
		if (status.getSeverity() == IStatus.ERROR) {
			// Job manager will pop the error dialog
		} else if (status.getSeverity() == IStatus.OK) {
        	Display display = PlatformUI.getWorkbench().getDisplay();
			display.syncExec(new Runnable() {
				public void run() {
					MessageDialog
					.openInformation(
							getManagedForm().getForm().getShell(),
							DeployCorePlugin
									.getDefault()
									.getResourceString(
											"ConfigurationPage.success.title"), DeployCorePlugin.getDefault().getResourceString("ConfigurationPage.success.message")); //$NON-NLS-1$ //$NON-NLS-2$
				}
			});					
		} else if (status.getSeverity() == IStatus.CANCEL) {
			// do nothing
		} else {
			DeployCorePlugin.getDefault().log(status);
			Display display = PlatformUI.getWorkbench().getDisplay();
			display.syncExec(new Runnable() {
				public void run() {
					MessageDialog.openError(getManagedForm().getForm()
							.getShell(),
							DeployCorePlugin.getDefault()
									.getResourceString(
											"ConfigurationPage.error.title"), //$NON-NLS-1$
							DeployCorePlugin.getDefault()
									.getResourceString(
											"ConfigurationPage.error.message")); //$NON-NLS-1$							
				}
			});
		}
	}
}