/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.editors.FormOutlinePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.editor.IFormPage;


/**
 * @author rcernich
 *
 * Created on Mar 4, 2004
 */
public class DeployFileOutlinePage extends FormOutlinePage {

	/**
	 * @param editor
	 */
	public DeployFileOutlinePage(EMFFormEditor editor) {
		super(editor);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.ui.editors.FormOutlinePage#createContentProvider()
	 */
	protected ITreeContentProvider createContentProvider() {
		return super.createContentProvider();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.IPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		super.createControl(parent);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.ui.editors.FormOutlinePage#createLabelProvider()
	 */
	protected ILabelProvider createLabelProvider() {
		return super.createLabelProvider();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.ui.editors.FormOutlinePage#getParentPage(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected IFormPage getParentPage(IStructuredSelection selection) {
		Object element = selection.isEmpty() ? null : selection.getFirstElement();
		if (element instanceof DeployPackage) {
			return getEditor().getActivePageInstance();
		}
		else if (element instanceof DeployServer) {
			return getEditor().getActivePageInstance();
		}
		return super.getParentPage(selection);
	}

}
