/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.controls.EMFTextControl;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * @author rcernich
 * 
 * Created on Jan 21, 2004
 */
public class GeneralInfoSection extends DeployEditorSectionPart {

	public static final String SECTION_TITLE = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECTITLE.GeneralInfo"); //$NON-NLS-1$
	public static final String SECTION_DESC = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECDESC.GeneralInfo"); //$NON-NLS-1$

	public static final String LABEL_NAME = DeployCorePlugin.getDefault()
			.getResourceString("LABEL.Name"); //$NON-NLS-1$
	public static final String LABEL_DESCRIPTION = DeployCorePlugin
			.getDefault().getResourceString("LABEL.Description"); //$NON-NLS-1$

	private EMFTextControl mNameText;
	private EMFTextControl mDescText;

	private Root mRoot;

	/**
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public GeneralInfoSection(Composite parent, FormToolkit toolkit, int style) {
		super(parent, toolkit, style);
		getSection().setText(SECTION_TITLE);
		getSection().setDescription(SECTION_DESC);
	}

	public void createClient(FormToolkit toolkit) {
		Composite container = toolkit.createComposite(getSection());
		GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
		layout.makeColumnsEqualWidth = false;
		layout.numColumns = 2;
		container.setLayout(layout);

		Label label = toolkit.createLabel(container, LABEL_NAME);
		GridData gd = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		label.setLayoutData(gd);

		Text text = toolkit.createText(container, null);
		gd = new GridData(GridData.FILL_HORIZONTAL
				| GridData.VERTICAL_ALIGN_BEGINNING);
		text.setLayoutData(gd);
		text.addModifyListener(new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				handleNameModified();
			}
		});
		mNameText = new EMFTextControl(text, DeployFilePackage.eINSTANCE
				.getRoot_Name());

		label = toolkit.createLabel(container, LABEL_DESCRIPTION);
		gd = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		label.setLayoutData(gd);

		text = toolkit.createText(container, null, SWT.MULTI | SWT.WRAP
				| SWT.V_SCROLL);
		gd = new GridData(GridData.FILL_BOTH);
		gd.heightHint = text.getLineHeight() * 5;
		text.setLayoutData(gd);
		text.addModifyListener(new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				handleDescriptionModified();
			}
		});
		mDescText = new EMFTextControl(text, DeployFilePackage.eINSTANCE
				.getRoot_Description());

		getSection().setClient(container);

		toolkit.paintBordersFor(container);
	}

    protected void helpActivated(HyperlinkEvent event)
    {
       HelpUtilities.displayHelp(IHelpConstants.CONTEXT_ID_OVERVIEW_PAGE_OVERVIEW_SECTION);
    }
	protected void setModelRoot(EObject modelRoot) {
		if (modelRoot instanceof Root) {
			mRoot = (Root) modelRoot;
			initControls();
		}
	}

	private void initControls() {
		mNameText.setOwner(mRoot);
		mDescText.setOwner(mRoot);
	}

	private void handleNameModified() {
		String text = mNameText.getText();
		if (!text.equals(mRoot.getName())) {
			EditingDomain editingDomain = getResourceEditingContainer()
					.getEditingDomain();
			Command setCommand = SetCommand.create(editingDomain, mRoot,
					DeployFilePackage.eINSTANCE.getRoot_Name(), text);
			editingDomain.getCommandStack().execute(setCommand);
		}
	}

	private void handleDescriptionModified() {
		String text = mDescText.getText();
		if (!text.equals(mRoot.getDescription())) {
			EditingDomain editingDomain = getResourceEditingContainer()
					.getEditingDomain();
			Command setCommand = SetCommand.create(editingDomain, mRoot,
					DeployFilePackage.eINSTANCE.getRoot_Description(), text);
			editingDomain.getCommandStack().execute(setCommand);
		}
	}

}