/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/**
 * @author rcernich
 * 
 * Created on Jan 17, 2005
 */
public class IntroductionPage extends EMFFormPage {

	public static final String PAGE_TITLE = DeployCorePlugin
			.getDefault()
			.getResourceString("DeployDefinitionEditor.PGTITLE.Introduction"); //$NON-NLS-1$

	private IntroductionSection mIntroduction;

	/**
	 * @param editor
	 * @param title
	 */
	public IntroductionPage(EMFFormEditor editor, String id, String title) {
		super(editor, id, title);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.FormPage#createFormContent(org.eclipse.ui.forms.IManagedForm)
	 */
	protected void createFormContent(IManagedForm managedForm) {
		super.createFormContent(managedForm);

		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();

		form.setText(PAGE_TITLE);

		GridLayout layout = EnhancedFormEditor.newPageGridLayout();
		layout.numColumns = 1;
		layout.makeColumnsEqualWidth = true;
		form.getBody().setLayout(layout);

		mIntroduction = new IntroductionSection(form.getBody(), toolkit,
				Section.DESCRIPTION | ExpandableComposite.TITLE_BAR);
		mIntroduction.createClient(toolkit);
		GridData gd = new GridData(GridData.FILL_BOTH);
		mIntroduction.getSection().setLayoutData(gd);
		managedForm.addPart(mIntroduction);
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(form, IHelpConstants.CONTEXT_ID_INTRODUCTION_PAGE);
	}
}