/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/**
 * @author rcernich
 * 
 * Created on Jan 21, 2004
 */
public class OverviewPage extends EMFFormPage {

	public static final String PAGE_TITLE = DeployCorePlugin.getDefault()
			.getResourceString("DeployDefinitionEditor.PGTITLE.Overview"); //$NON-NLS-1$

	private GeneralInfoSection mGeneralInfo;
	private PackagesSection mPackages;
	private ServersSection mServers;

	/**
	 * @param editor
	 * @param title
	 */
	public OverviewPage(EMFFormEditor editor, String id, String title) {
		super(editor, id, title);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.editor.FormPage#createFormContent(org.eclipse.ui.forms.IManagedForm)
	 */
	protected void createFormContent(IManagedForm managedForm) {
		super.createFormContent(managedForm);

		ScrolledForm form = managedForm.getForm();
		FormToolkit toolkit = managedForm.getToolkit();

		form.setText(PAGE_TITLE);

		GridLayout layout = EnhancedFormEditor.newPageGridLayout();
		layout.numColumns = 2;
		layout.makeColumnsEqualWidth = true;
		form.getBody().setLayout(layout);

		mGeneralInfo = new GeneralInfoSection(form.getBody(), toolkit,
				Section.DESCRIPTION | ExpandableComposite.TITLE_BAR);
		mGeneralInfo.createClient(toolkit);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 2;
		mGeneralInfo.getSection().setLayoutData(gd);
		managedForm.addPart(mGeneralInfo);

		mPackages = new PackagesSection(form.getBody(), toolkit,
				Section.DESCRIPTION | ExpandableComposite.TITLE_BAR);
		mPackages.createClient(toolkit);
		gd = new GridData(GridData.FILL_BOTH);
		mPackages.getSection().setLayoutData(gd);
		managedForm.addPart(mPackages);

		mServers = new ServersSection(form.getBody(), toolkit,
				Section.DESCRIPTION | ExpandableComposite.TITLE_BAR);
		mServers.createClient(toolkit);
		gd = new GridData(GridData.FILL_BOTH);
		mServers.getSection().setLayoutData(gd);
		managedForm.addPart(mServers);
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(form, IHelpConstants.CONTEXT_ID_OVERVIEW_PAGE);

	}

}