/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * @author rcernich
 * 
 * Created on Jan 21, 2004
 */
public class PackageDescriptionSection extends DeployEditorSectionPart
		implements IPartSelectionListener {

	public static final String SECTION_TITLE = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECTITLE.PackageDescription"); //$NON-NLS-1$
	public static final String SECTION_DESC = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECDESC.PackageDescription"); //$NON-NLS-1$

	private Text mDescText;

	/**
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public PackageDescriptionSection(Composite parent, FormToolkit toolkit,
										int style) {
		super(parent, toolkit, style);
		getSection().setText(SECTION_TITLE);
		getSection().setDescription(SECTION_DESC);
	}

	public void createClient(FormToolkit toolkit) {
		Composite container = toolkit.createComposite(getSection());
		GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
		layout.numColumns = 1;
		container.setLayout(layout);

		mDescText = toolkit.createText(container, new String(), SWT.MULTI
				| SWT.WRAP | SWT.V_SCROLL | SWT.READ_ONLY);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.heightHint = mDescText.getLineHeight() * 5;
		mDescText.setLayoutData(gd);

		getSection().setClient(container);

		toolkit.paintBordersFor(container);
	}

    protected void helpActivated(HyperlinkEvent event)
    {
       HelpUtilities.displayHelp(IHelpConstants.CONTEXT_ID_CONFIGURATION_PAGE_PACKAGE_DESCRIPTION_SECTION);
    }

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.editors.EMFSectionPart#setModelRoot(org.eclipse.emf.ecore.EObject)
	 */
	protected void setModelRoot(EObject modelRoot) {
		// Nothing to do.
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.IPartSelectionListener#selectionChanged(org.eclipse.ui.forms.IFormPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IFormPart part, ISelection selection) {
		if (!selection.isEmpty()) {
			Object element = ((IStructuredSelection) selection)
					.getFirstElement();
			if (element instanceof EObject) {
				IPackage pkg = Utilities.adaptToIPackage((EObject) element);
				if (pkg != null) {
					String description = pkg.getDescription();
					if (description == null) {
						description = new String();
					}
					mDescText.setText(description);
				}
			}
		}
	}
}