/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.eclipse.core.resources.IFile;
import org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFileFactory;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.TargetMapTableViewer;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.ServerSelectionDialogPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

/**
 * @author rcernich
 * 
 * Created on Jan 28, 2004
 */
public class PackageTargetWizardPage extends WizardPage implements
		ISummaryDataSource {

	public static final String LABEL_TARGETS;
	public static final String LABEL_SELECT_TARGET;
	public static final String LABEL_EXECUTE;
	public static final int MIN_TREE_HEIGHT;

	private TargetMapTableViewer mTargetMap;
	private Button mSelectTargetButton;
	private Button mExecuteButton;
	private Root mRoot;
	private Map mFileToPackageMap = new HashMap();
	private boolean mTargetsSpecified = false;

	/**
	 * @param pageName
	 */
	public PackageTargetWizardPage(String pageName) {
		super(pageName);
	}

	/**
	 * @param pageName
	 * @param title
	 * @param titleImage
	 */
	public PackageTargetWizardPage(String pageName, String title,
									ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}

	public void init(Root root) {
		mRoot = root;
	}

	public boolean getExecuteDeployment() {
		boolean retVal;
		if (mExecuteButton != null && mExecuteButton.isEnabled()) {
			retVal = mExecuteButton.getSelection();
		}
		else {
			retVal = false;
		}
		return retVal;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible) {
		if (visible) {
			IFile[] packages = ((DeployFileNewWizard) getWizard())
					.getSelectedPackages();
			updatePackages(packages);
			mExecuteButton.setEnabled(packages.length == 0);
		}
		super.setVisible(visible);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout(2, false));
		content.setLayoutData(new GridData(GridData.FILL_BOTH));

		Label label = new Label(content, SWT.NULL);
		label.setText(LABEL_TARGETS);
		GridData data = new GridData();
		data.horizontalSpan = 2;
		label.setLayoutData(data);

		mTargetMap = new TargetMapTableViewer(new Table(content, SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.BORDER | SWT.SINGLE | SWT.FULL_SELECTION));
		data = new GridData(GridData.FILL_BOTH);
		data.heightHint = mTargetMap.getViewer().getTable().getItemHeight()
				* MIN_TREE_HEIGHT;
		mTargetMap.getViewer().getTable().setLayoutData(data);
		mTargetMap.getViewer().addSelectionChangedListener(
				new ISelectionChangedListener() {

					public void selectionChanged(SelectionChangedEvent event) {
						handleTargetMapSelectionChanged();
					}
				});

		mSelectTargetButton = new Button(content, SWT.PUSH);
		mSelectTargetButton.setText(LABEL_SELECT_TARGET);
		data = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		GC gc = new GC(mSelectTargetButton);
		gc.setFont(mSelectTargetButton.getFont());
		FontMetrics fontMetrics = gc.getFontMetrics();
		gc.dispose();
		int buttonHeight = Dialog.convertVerticalDLUsToPixels(fontMetrics,
				IDialogConstants.BUTTON_HEIGHT);
		int buttonWidth = Dialog.convertHorizontalDLUsToPixels(fontMetrics,
				IDialogConstants.BUTTON_WIDTH);
		data.heightHint = buttonHeight;
		data.widthHint = Math.max(buttonWidth, mSelectTargetButton.computeSize(
				SWT.DEFAULT, SWT.DEFAULT, true).x);
		mSelectTargetButton.setLayoutData(data);
		mSelectTargetButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				handleSelectTarget();
			}
		});

		mExecuteButton = new Button(content, SWT.CHECK);
		mExecuteButton.setText(LABEL_EXECUTE);
		data = new GridData();
		mExecuteButton.setLayoutData(data);
		mExecuteButton.addSelectionListener(new SelectionAdapter() {

			public void widgetSelected(SelectionEvent e) {
				handleExecuteSelected();
			}
		});

		initControls();

		setControl(content);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.datatools.connectivity.internal.ui.wizards.ISummaryDataSource#getSummaryData()
	 */
	public List getSummaryData() {
		List summaryData = new ArrayList(mRoot.getPackage().size() + 2);

		summaryData.add(new String[] {
				DeployCorePlugin.getDefault().getResourceString(
						"PackageTargetWizardPage.summary.targetServers"), //$NON-NLS-1$
				new String()});

		for (Iterator it = mRoot.getPackage().iterator(); it.hasNext();) {
			DeployPackage dp = (DeployPackage) it.next();
			IPackage ip = Utilities.adaptToIPackage(dp);
			String target = new String();
			if (dp.getTargetConfiguration().size() > 0) {
				DeployConfiguration dc = (DeployConfiguration) dp
						.getTargetConfiguration().get(0);
				if (dc.getTargetServer() != null) {
					target = dc.getTargetServer().getProfileName();
				}
			}
			summaryData.add(new String[] {
					"   " + ip.getFile().getFullPath().toString(), target}); //$NON-NLS-1$
		}

		summaryData.add(new String[] {
				DeployCorePlugin.getDefault().getResourceString(
						"PackageTargetWizardPage.summary.executeDeployment"), //$NON-NLS-1$
				String.valueOf(getExecuteDeployment())});

		return summaryData;
	}

	private void initControls() {
		mTargetMap.getViewer().setInput(mRoot);

		validate();

		updateControls();
	}

	private void updateControls() {
		mExecuteButton.setEnabled(mTargetsSpecified);
		mSelectTargetButton.setEnabled(((IStructuredSelection) mTargetMap
				.getViewer().getSelection()).size() == 1);
	}

	private void validate() {
		mTargetsSpecified = true;
		for (Iterator it = mRoot.getPackage().iterator(); mTargetsSpecified
				&& it.hasNext();) {
			DeployPackage pkg = (DeployPackage) it.next();
			mTargetsSpecified = mTargetsSpecified
					&& pkg.getTargetConfiguration().size() > 0;
		}
		if (mTargetsSpecified) {
			setMessage(null, WARNING);
		}
		else {
			setMessage(DeployCorePlugin.getDefault().getResourceString(
					"PackageTargetWizardPage.summary.targetServers"), WARNING); //$NON-NLS-1$
		}
		setPageComplete(true);
	}

	private void handleTargetMapSelectionChanged() {
		validate();

		updateControls();
	}

	private void handleSelectTarget() {
		DeployPackage pkg = (DeployPackage) ((IStructuredSelection) mTargetMap
				.getViewer().getSelection()).getFirstElement();
		DeployServer target = null;
		DeployConfiguration config = null;
		if (pkg.getTargetConfiguration().size() > 0) {
			config = (DeployConfiguration) pkg.getTargetConfiguration().get(0);
			target = config.getTargetServer();
		}
		ServerSelectionDialogPage page = new ServerSelectionDialogPage();
		page.init(pkg, target);
		Dialog dialog = new Dialog(getShell(), page);
		if (dialog.open() == Dialog.OK) {
			target = page.getSelectedDeployServer();
			if (target.getRoot() == null) {
				// New server
				target.setRoot(mRoot);
			}
			if (config == null) {
				DeployFilePackage.eINSTANCE.getDeployFileFactory()
						.createDeployConfiguration(target, pkg);
			}
			else {
				config.setTargetServer(target);
			}
			validate();

			updateControls();
		}
	}

	private void handleExecuteSelected() {
	}

	private void updatePackages(IFile[] packages) {
		DeployFileFactory factory = DeployFilePackage.eINSTANCE
				.getDeployFileFactory();
		Vector unseen = new Vector(mFileToPackageMap.values());
		for (int index = 0, count = packages.length; index < count; ++index) {
			DeployPackage dp = (DeployPackage) mFileToPackageMap
					.get(packages[index]);
			if (dp == null) {
				dp = factory.createDeployPackage(mRoot, packages[index]
						.getProjectRelativePath().toString());
				mFileToPackageMap.put(packages[index], dp);
			}
			else {
				dp.setRoot(mRoot);
				unseen.remove(dp);
			}
		}
		for (Iterator it = unseen.iterator(); it.hasNext();) {
			DeployPackage dp = (DeployPackage) it.next();
			dp.setRoot(null);
			// TODO: think about removing unused target servers.
		}
	}

	static {
		LABEL_TARGETS = DeployCorePlugin.getDefault().getResourceString(
				"LABEL.PackageTargets"); //$NON-NLS-1$
		LABEL_SELECT_TARGET = DeployCorePlugin.getDefault()
				.getResourceString("BUTTON.SelectTarget"); //$NON-NLS-1$
		LABEL_EXECUTE = DeployCorePlugin.getDefault().getResourceString(
				"BUTTON.ExecuteDeployment"); //$NON-NLS-1$
		MIN_TREE_HEIGHT = 15;
	}

}