/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.stp.soas.deploy.models.deployfile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Deploy Server</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployServerImpl#getTargetingConfiguration <em>Targeting Configuration</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployServerImpl#getRoot <em>Root</em>}</li>
 *   <li>{@link org.eclipse.stp.soas.deploy.models.deployfile.impl.DeployServerImpl#getProfileName <em>Profile Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DeployServerImpl extends EObjectImpl implements DeployServer {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "(c) 2004 Sybase, Inc.";

	/**
	 * The cached value of the '{@link #getTargetingConfiguration() <em>Targeting Configuration</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetingConfiguration()
	 * @generated
	 * @ordered
	 */
	protected EList targetingConfiguration = null;

	/**
	 * The default value of the '{@link #getProfileName() <em>Profile Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProfileName()
	 * @generated
	 * @ordered
	 */
	protected static final String PROFILE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProfileName() <em>Profile Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProfileName()
	 * @generated
	 * @ordered
	 */
	protected String profileName = PROFILE_NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeployServerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DeployFilePackage.Literals.DEPLOY_SERVER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getTargetingConfiguration() {
		if (targetingConfiguration == null) {
			targetingConfiguration = new EObjectWithInverseResolvingEList.Unsettable(
					DeployConfiguration.class, this,
					DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION,
					DeployFilePackage.DEPLOY_CONFIGURATION__TARGET_SERVER);
		}
		return targetingConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetTargetingConfiguration() {
		((InternalEList.Unsettable) getTargetingConfiguration()).unset();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetTargetingConfiguration() {
		return targetingConfiguration != null
				&& ((InternalEList.Unsettable) targetingConfiguration).isSet();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Root getRoot() {
		if (eContainerFeatureID != DeployFilePackage.DEPLOY_SERVER__ROOT)
			return null;
		return (Root) eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRoot(Root newRoot) {
		if (newRoot != eInternalContainer()
				|| (eContainerFeatureID != DeployFilePackage.DEPLOY_SERVER__ROOT && newRoot != null)) {
			if (EcoreUtil.isAncestor(this, newRoot))
				throw new IllegalArgumentException(
						"Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newRoot != null)
				msgs = ((InternalEObject) newRoot).eInverseAdd(this,
						DeployFilePackage.ROOT__SERVER, Root.class, msgs);
			msgs = eBasicSetContainer((InternalEObject) newRoot,
					DeployFilePackage.DEPLOY_SERVER__ROOT, msgs);
			if (msgs != null)
				msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DeployFilePackage.DEPLOY_SERVER__ROOT, newRoot, newRoot));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getProfileName() {
		return profileName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProfileName(String newProfileName) {
		String oldProfileName = profileName;
		profileName = newProfileName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					DeployFilePackage.DEPLOY_SERVER__PROFILE_NAME,
					oldProfileName, profileName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION:
			return ((InternalEList) getTargetingConfiguration()).basicAdd(
					otherEnd, msgs);
		case DeployFilePackage.DEPLOY_SERVER__ROOT:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return eBasicSetContainer(otherEnd,
					DeployFilePackage.DEPLOY_SERVER__ROOT, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION:
			return ((InternalEList) getTargetingConfiguration()).basicRemove(
					otherEnd, msgs);
		case DeployFilePackage.DEPLOY_SERVER__ROOT:
			return eBasicSetContainer(null,
					DeployFilePackage.DEPLOY_SERVER__ROOT, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID) {
		case DeployFilePackage.DEPLOY_SERVER__ROOT:
			return eInternalContainer().eInverseRemove(this,
					DeployFilePackage.ROOT__SERVER, Root.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION:
			return getTargetingConfiguration();
		case DeployFilePackage.DEPLOY_SERVER__ROOT:
			return getRoot();
		case DeployFilePackage.DEPLOY_SERVER__PROFILE_NAME:
			return getProfileName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION:
			getTargetingConfiguration().clear();
			getTargetingConfiguration().addAll((Collection) newValue);
			return;
		case DeployFilePackage.DEPLOY_SERVER__ROOT:
			setRoot((Root) newValue);
			return;
		case DeployFilePackage.DEPLOY_SERVER__PROFILE_NAME:
			setProfileName((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION:
			unsetTargetingConfiguration();
			return;
		case DeployFilePackage.DEPLOY_SERVER__ROOT:
			setRoot((Root) null);
			return;
		case DeployFilePackage.DEPLOY_SERVER__PROFILE_NAME:
			setProfileName(PROFILE_NAME_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DeployFilePackage.DEPLOY_SERVER__TARGETING_CONFIGURATION:
			return isSetTargetingConfiguration();
		case DeployFilePackage.DEPLOY_SERVER__ROOT:
			return getRoot() != null;
		case DeployFilePackage.DEPLOY_SERVER__PROFILE_NAME:
			return PROFILE_NAME_EDEFAULT == null ? profileName != null
					: !PROFILE_NAME_EDEFAULT.equals(profileName);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (profileName: ");
		result.append(profileName);
		result.append(')');
		return result.toString();
	}

} //DeployServerImpl
