/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.soas.deploy.tomcat.cp;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.VersionProviderConnection;

public class TomcatConnection extends VersionProviderConnection implements
		IConnection {

	public static String TOMCAT_WEBDIR = "webapps";
	
	File tomcatDir;
	Exception connectException;

    public TomcatConnection(IConnectionProfile profile) {
		super(profile, TomcatConnectionFactory.class);
		Properties props = profile.getBaseProperties();
		String dir = props.getProperty(IConnectionConstants.PROFILEPPROPERTY_DIR);
		tomcatDir = new File(dir + File.separator + TOMCAT_WEBDIR);
		if (tomcatDir.exists()) {
		    updateVersionCache();
		} else {
			connectException = new IOException(tomcatDir + " does not exists");
			clearVersionCache();
		}
	}

	
	@Override
	protected String getTechnologyRootKey() {
		return IConnectionConstants.TECHNOLOGY_ROOT_KEY;
	}
	

	public void close() { 
		//do nothing for close. since it is file based deployment
	}

	public Throwable getConnectException() {
		return connectException;
	}

	public Object getRawConnection() {
		return tomcatDir;
	}

	public String getProviderName() {
		return IConnectionConstants.PROVIDER_NAME;
	}

	public Version getProviderVersion() {
		return Version.valueOf(IConnectionConstants.PROVIDER_VERSION);
	}

	public String getTechnologyName() {
		return IConnectionConstants.TECH_NAME;
	}

	public Version getTechnologyVersion() {
		return Version.valueOf(IConnectionConstants.TECH_VERSION);
	}

}
