/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPClientTransport;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPServerTransportListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPClientTransportHTTP;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPServerTransportHTTP;
import org.eclipse.stp.b2j.core.publicapi.B2jConfig;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;

public class SOAPFactory {
    private static Object config_LOCK = new Object();
    private static boolean loaded = false;
    private static String httpsHost = null;
    private static int httpsPort = 8080;
    private static String httpHost = null;
    private static int httpPort = 8080;
    private static String[] excludedHosts = new String[0];
    public static final boolean DEBUG = false;
    static HashMap soapClients = new HashMap();
    static Object soapClients_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetProxySettings() {
        Object object = config_LOCK;
        synchronized (object) {
            loaded = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProxySettings() {
        Object object = config_LOCK;
        synchronized (object) {
            if (loaded) {
                return;
            }
            B2jConfig config = B2jPlatform.getB2jConfig();
            if (config != null) {
                String[] SOAP_PROXY_EXCLUDED_HOSTS;
                String s = config.getProperty("Config/Soap/HttpsProxy/Use");
                if (s != null && s.equals("true")) {
                    httpsHost = config.getProperty("Config/Soap/HttpsProxy/Host");
                    httpsPort = Integer.parseInt(config.getProperty("Config/Soap/HttpsProxy/Port"));
                }
                if ((s = config.getProperty("Config/Soap/HttpProxy/Use")) != null && s.equals("true")) {
                    httpHost = config.getProperty("Config/Soap/HttpProxy/Host");
                    httpPort = Integer.parseInt(config.getProperty("Config/Soap/HttpProxy/Port"));
                }
                try {
                    ArrayList<String> tmp = new ArrayList<String>();
                    String proxy_hosts = config.getProperty("Config/Soap/ExcludedProxyHosts");
                    if (proxy_hosts == null) {
                        SOAP_PROXY_EXCLUDED_HOSTS = new String[]{};
                    } else {
                        int index;
                        do {
                            String proxy_host_tmp;
                            if ((index = proxy_hosts.indexOf(44)) != -1) {
                                proxy_host_tmp = proxy_hosts.substring(0, index);
                                proxy_hosts = proxy_hosts.substring(index + 1);
                            } else {
                                proxy_host_tmp = proxy_hosts;
                            }
                            proxy_host_tmp = proxy_host_tmp.trim();
                            if (proxy_host_tmp.length() <= 0) continue;
                            tmp.add(proxy_host_tmp);
                        } while (index != -1);
                        SOAP_PROXY_EXCLUDED_HOSTS = new String[tmp.size()];
                        tmp.toArray(SOAP_PROXY_EXCLUDED_HOSTS);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    SOAP_PROXY_EXCLUDED_HOSTS = new String[]{};
                }
                excludedHosts = SOAP_PROXY_EXCLUDED_HOSTS;
            }
            loaded = true;
        }
    }

    public static void addServerTransportListenerForEPR(WSEndpointReference epr, String transportURI, boolean rpc_type, SOAPServerTransportListener listener) throws Exception {
        if (transportURI == null) {
            String addr = epr.getAddress();
            String lc_addr = addr.toLowerCase();
            if (lc_addr.startsWith("http")) {
                transportURI = "http://schemas.xmlsoap.org/soap/http";
            } else {
                throw new Exception("Could not detect valid SOAP transport for endpoint reference (" + addr + ")");
            }
        }
        if (!transportURI.equalsIgnoreCase("http://schemas.xmlsoap.org/soap/http")) {
            throw new Exception("Could not detect valid SOAP transport for URI \"" + transportURI + "\"");
        }
        new SOAPServerTransportHTTP(epr, rpc_type, listener);
    }

    public static SOAPClientTransport getClientTransportForEPR(WSEndpointReference epr, BPELCorrelationSet cset, String transportURI) throws Exception {
        String addr;
        if (transportURI == null) {
            addr = epr.getAddress();
            String lc_addr = addr.toLowerCase();
            if (lc_addr.startsWith("http")) {
                transportURI = "http://schemas.xmlsoap.org/soap/http";
            } else {
                throw new Exception("Could not detect valid SOAP transport for endpoint reference");
            }
        }
        if (transportURI.equalsIgnoreCase("http://schemas.xmlsoap.org/soap/http")) {
            addr = epr.getAddress().toLowerCase();
            String proxy_host = null;
            int proxy_port = 8080;
            SOAPFactory.loadProxySettings();
            if (addr.startsWith("https")) {
                proxy_host = httpsHost;
                proxy_port = httpsPort;
            } else {
                proxy_host = httpHost;
                proxy_port = httpPort;
            }
            SOAPFactory.loadProxySettings();
            String[] SOAP_PROXY_EXCLUDED_HOSTS = excludedHosts;
            return new SOAPClientTransportHTTP(epr.getAddress(), cset, proxy_host, proxy_port, SOAP_PROXY_EXCLUDED_HOSTS);
        }
        throw new Exception("Could not detect valid SOAP transport for URI \"" + transportURI + "\"");
    }
}

