/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.CookieCache;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;

public class HTTPClient {
    public static final int TIMEOUT = 120000;
    private static final int RETRIES = 1;
    URL address;
    Socket sock;
    OutputStream sout;
    InputStream sin;
    String host;
    int port;
    String hostandport;
    String protocol;
    String resource;
    String fullurl;
    boolean secureprotocol = false;
    String version = "HTTP/1.1";
    String proxy_host;
    int proxy_port;

    public HTTPClient(URL address) throws IOException {
        System.out.println("************* NEW CLIENT");
        this.address = address;
        this.host = address.getHost();
        this.port = address.getPort();
        if (this.port == -1) {
            try {
                this.port = HTTPUtils.getDefaultPort(address);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                this.port = address.getProtocol().equalsIgnoreCase("http") ? 80 : (address.getProtocol().equalsIgnoreCase("https") ? 443 : 80);
            }
        }
        this.hostandport = String.valueOf(this.host) + ":" + this.port;
        this.protocol = address.getProtocol();
        this.resource = address.getFile();
        this.fullurl = address.toString();
        if (this.resource == null) {
            this.resource = "/";
        }
        if (this.resource.length() == 0) {
            this.resource = "/";
        }
    }

    private void setResource(String res) {
        this.resource = res;
        if (this.resource == null) {
            this.resource = "/";
        }
        if (this.resource.length() == 0) {
            this.resource = "/";
        }
    }

    public void setResource(URL url) {
        this.setResource(url.getFile());
        this.fullurl = url.toString();
    }

    private void connect() throws IOException {
        int connect_port;
        System.out.println("************* HTTP CLIENT CONNECT");
        String connect_host = null;
        if (this.proxy_host != null) {
            connect_host = this.proxy_host;
            connect_port = this.proxy_port;
        } else {
            connect_host = this.address.getHost();
            connect_port = this.port;
        }
        if (this.protocol.equalsIgnoreCase("http")) {
            this.secureprotocol = false;
            this.sock = new Socket(connect_host, connect_port);
        } else if (this.protocol.equalsIgnoreCase("https")) {
            this.secureprotocol = true;
            try {
                Class[] c_empty = new Class[]{};
                Object[] a_empty = new Object[]{};
                Class<?> c_factory = Class.forName("javax.net.ssl.SSLSocketFactory");
                Object o_factory = c_factory.getMethod("getDefault", c_empty).invoke(null, a_empty);
                Socket sslsock = (Socket)c_factory.getMethod("createSocket", String.class, Integer.TYPE).invoke(o_factory, connect_host, new Integer(connect_port));
                Class<?> c_sslsock = Class.forName("javax.net.ssl.SSLSocket");
                String[] suites = (String[])c_sslsock.getMethod("getSupportedCipherSuites", c_empty).invoke((Object)sslsock, a_empty);
                c_sslsock.getMethod("setEnabledCipherSuites", String[].class).invoke((Object)sslsock, new Object[]{suites});
                c_sslsock.getMethod("setNeedClientAuth", Boolean.TYPE).invoke((Object)sslsock, Boolean.FALSE);
                c_sslsock.getMethod("setWantClientAuth", Boolean.TYPE).invoke((Object)sslsock, Boolean.FALSE);
                this.sock = sslsock;
            }
            catch (Exception e) {
                throw new IOException("Unable to load javax.net.ssl SSL classes for HTTPS support (" + e + ")");
            }
        }
        this.sock.setSoTimeout(120000);
        this.sout = new BufferedOutputStream(this.sock.getOutputStream());
        this.sin = new BufferedInputStream(this.sock.getInputStream());
    }

    public void setProxy(String host, int port) {
        boolean reconnect = false;
        if (host == null) {
            if (this.proxy_host != null) {
                reconnect = true;
                this.proxy_host = null;
            }
        } else if (this.proxy_host == null) {
            reconnect = true;
            this.proxy_host = host;
        } else if (!this.proxy_host.equals(host)) {
            reconnect = true;
            this.proxy_host = host;
        }
        if (this.proxy_port != port) {
            reconnect = true;
            this.proxy_port = port;
        }
        if (reconnect) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() throws IOException {
        System.out.println("************* CLIENT CLOSED");
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    private void writeMandatoryHeaders(String mimetype) throws IOException {
        if (this.version != "HTTP/1.0") {
            HTTPUtils.writeHeader(this.sout, "host", this.hostandport);
        }
        if (mimetype != null) {
            HTTPUtils.writeHeader(this.sout, "content-type", mimetype);
        }
    }

    private void writeHeaders(String[][] headers) throws IOException {
        int i = 0;
        while (i < headers.length) {
            HTTPUtils.writeHeader(this.sout, headers[i][0], headers[i][1]);
            ++i;
        }
    }

    private void writeCookieHeaders(CookieCache cookies) throws IOException {
        String cookieValue;
        if (cookies != null && (cookieValue = cookies.getCookies(this.host, this.resource, this.secureprotocol)).length() > 0) {
            HTTPUtils.writeHeader(this.sout, "cookie", cookieValue);
        }
    }

    private void writeContent(byte[] dat) throws IOException {
        if (dat != null) {
            if (dat.length != 0) {
                HTTPUtils.writeHeader(this.sout, "content-length", Integer.toString(dat.length));
            } else {
                dat = null;
                HTTPUtils.writeHeader(this.sout, "content-length", "0");
            }
        } else {
            HTTPUtils.writeHeader(this.sout, "content-length", "0");
        }
        HTTPUtils.writeHeadersEnd(this.sout);
        if (dat != null) {
            HTTPUtils.writeContent(this.sout, dat);
        }
    }

    private String readResponse(CookieCache cookies) throws IOException {
        boolean finished = false;
        String res_code = null;
        while (!finished) {
            CharStack stack = new CharStack(new String(StreamUtils.readLine(this.sin)));
            stack.popWhitespace();
            stack.popText(true);
            stack.popWhitespace();
            res_code = stack.popText(true);
            if (res_code.equals("100")) {
                this.readContent(cookies);
                continue;
            }
            finished = true;
        }
        return res_code;
    }

    private byte[] readContent(CookieCache cookies) throws IOException {
        String res_content_type = null;
        int res_content_len = 0;
        boolean closeConnection = false;
        boolean chunked = false;
        String header = new String(StreamUtils.readLine(this.sin));
        while (header.trim().length() > 0) {
            int index = header.indexOf(58);
            if (index >= 0) {
                String key = header.substring(0, index).trim().toLowerCase();
                String value = header.substring(index + 1);
                if (key.equals("content-length")) {
                    res_content_len = Integer.parseInt(value.trim());
                } else if (key.equals("content-type")) {
                    res_content_type = value;
                } else if (key.equals("connection")) {
                    if (value.trim().toLowerCase().equals("close")) {
                        closeConnection = true;
                    }
                } else if (key.equals("transfer-encoding")) {
                    if (value.trim().toLowerCase().equals("chunked")) {
                        chunked = true;
                    }
                } else if (key.equals("set-cookie")) {
                    if (cookies != null) {
                        cookies.addCookie(value, this.host);
                    }
                } else {
                    key.equals("location");
                }
            }
            header = new String(StreamUtils.readLine(this.sin));
        }
        byte[] content = null;
        if (!chunked) {
            if (res_content_len > 0) {
                content = StreamUtils.readBytes(this.sin, res_content_len);
            } else if (res_content_type != null && closeConnection) {
                content = StreamUtils.readAll(this.sin);
            } else if (res_content_type != null && !closeConnection) {
                closeConnection = true;
                content = StreamUtils.readAll(this.sin);
            } else {
                content = new byte[]{};
            }
        } else {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while (true) {
                int chunk_len;
                String chunk_header;
                int index;
                if ((index = (chunk_header = new String(StreamUtils.readLine(this.sin))).indexOf(59)) != -1) {
                    chunk_header = chunk_header.substring(0, index);
                }
                if ((chunk_len = Integer.parseInt(chunk_header = chunk_header.trim(), 16)) == 0) break;
                bout.write(StreamUtils.readBytes(this.sin, chunk_len));
                StreamUtils.readLine(this.sin);
            }
            String footer = new String(StreamUtils.readLine(this.sin));
            while (footer.trim().length() > 0) {
                footer = new String(StreamUtils.readLine(this.sin));
            }
            content = bout.toByteArray();
        }
        if (closeConnection) {
            this.close();
        }
        return content;
    }

    public byte[] doGet(String[][] headers) throws IOException {
        return this.doGet(headers, null);
    }

    public byte[] doGet(String[][] headers, CookieCache cookies) throws IOException {
        if (this.sock == null) {
            this.connect();
        }
        IOException last_error = null;
        int i = 0;
        while (i < 2) {
            try {
                if (this.proxy_host == null) {
                    HTTPUtils.writeInitialHeader(this.sout, "GET", this.resource, this.version);
                } else {
                    HTTPUtils.writeInitialHeader(this.sout, "GET", this.fullurl, this.version);
                }
                this.writeMandatoryHeaders(null);
                this.writeHeaders(headers);
                this.writeCookieHeaders(cookies);
                this.writeContent(null);
                this.sout.flush();
                this.readResponse(cookies);
                byte[] resp_dat = this.readContent(cookies);
                return resp_dat;
            }
            catch (IOException x) {
                last_error = x;
                if (x instanceof SocketException || x.getMessage().equals("End of stream")) {
                    if (i < 2) {
                        this.connect();
                    } else {
                        throw x;
                    }
                }
                ++i;
            }
        }
        if (last_error != null) {
            throw last_error;
        }
        throw new IOException("Unknown error");
    }

    public byte[] doPost(byte[] dat, String mimetype, String[][] headers) throws IOException {
        return this.doPost(dat, mimetype, headers, null);
    }

    public byte[] doPost(byte[] dat, String mimetype, String[][] headers, CookieCache cookies) throws IOException {
        if (this.sock == null) {
            this.connect();
        }
        IOException last_error = null;
        int i = 0;
        while (i < 2) {
            try {
                if (this.proxy_host == null) {
                    HTTPUtils.writeInitialHeader(this.sout, "POST", this.resource, this.version);
                } else {
                    HTTPUtils.writeInitialHeader(this.sout, "POST", this.fullurl, this.version);
                }
                this.writeMandatoryHeaders(mimetype);
                this.writeHeaders(headers);
                this.writeCookieHeaders(cookies);
                this.writeContent(dat);
                this.sout.flush();
                this.readResponse(cookies);
                byte[] resp_dat = this.readContent(cookies);
                return resp_dat;
            }
            catch (IOException x) {
                last_error = x;
                if (x instanceof SocketException || x.getMessage().equals("End of stream")) {
                    if (i < 2) {
                        this.connect();
                    } else {
                        throw x;
                    }
                }
                ++i;
            }
        }
        if (last_error != null) {
            throw last_error;
        }
        throw new IOException("Unknown error");
    }
}

