/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.portgen;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class WsdlGenerator
implements Comparator {
    ClassLoader cl;
    Class clazz;
    ByteArrayOutputStream bout;
    PrintStream pout;
    ByteArrayOutputStream bxout;
    PrintStream xout;
    ArrayList nss = new ArrayList();
    HashMap xsdMap = new HashMap();
    ArrayList xsdTypes = new ArrayList();
    String wsdl;
    int nsInsert;
    HashMap namespaces = new HashMap();
    int NS = 0;

    public WsdlGenerator(String classname, ArrayList allMethods) throws ClassNotFoundException {
        this.cl = ClassLoader.getSystemClassLoader();
        this.init(classname, allMethods);
    }

    public WsdlGenerator(String classname, ArrayList allMethods, ClassLoader cl) throws ClassNotFoundException {
        this.cl = cl;
        this.init(classname, allMethods);
    }

    public WsdlGenerator(String classname, ArrayList allMethods, URL[] jarurls) throws ClassNotFoundException {
        this.cl = new URLClassLoader(jarurls, Thread.currentThread().getContextClassLoader());
        this.init(classname, allMethods);
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void init(String classname, ArrayList allMethods) throws ClassNotFoundException {
        try {
            this.clazz = WsdlGenerator.class.getClassLoader().loadClass(classname);
        }
        catch (Exception exception) {
            this.clazz = this.cl.loadClass(classname);
        }
        String namespace = "http://" + this.clazz.getPackage().getName().replace('.', '_');
        this.bout = new ByteArrayOutputStream();
        this.pout = new PrintStream(this.bout);
        this.bxout = new ByteArrayOutputStream();
        this.xout = new PrintStream(this.bxout);
        this.pout.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.pout.println("<definitions xmlns=\"http://schemas.xmlsoap.org/wsdl/\"");
        this.pout.println("\t\t\ttargetNamespace=\"" + namespace + "\"");
        this.pout.println("\t\t\txmlns:tns=\"" + namespace + "\"");
        this.pout.println("\t\t\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        this.pout.println("\t\t\txmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"");
        this.pout.println("\t\t\txmlns:engine=\"http://www.eclipse.org/stp/b2j/2006/02\"");
        this.pout.println("\t\t\txmlns:format=\"http://schemas.xmlsoap.org/wsdl/formatbinding/\"");
        this.pout.println("\t\t\txmlns:java=\"http://schemas.xmlsoap.org/wsdl/java/\"");
        this.nsInsert = this.bout.size();
        this.pout.println(">");
        this.xout.println();
        this.xout.println("<!-- XSD types -->");
        this.xout.println("<types>");
        this.xout.println("\t<schema xmlns=\"http://www.w3.org/2001/XMLSchema\"");
        this.xout.println("\t\t\ttargetNamespace=\"" + namespace + "\"");
        this.xout.println("\t\t\txmlns:tns=\"" + namespace + "\"");
        this.xout.println("\t\t\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        this.xout.println("\t\t\txmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"");
        this.xout.println("\t\t\txmlns:engine=\"http://www.eclipse.org/stp/b2j/2006/02\"");
        this.xout.println("\t\t\txmlns:format=\"http://schemas.xmlsoap.org/wsdl/formatbinding/\"");
        this.xout.println("\t\t\txmlns:java=\"http://schemas.xmlsoap.org/wsdl/java/\"");
        this.xout.println("\t>");
        String portname = this.clazz.getName();
        portname = portname.substring(portname.lastIndexOf(46) + 1);
        Method[] methods = this.clazz.getDeclaredMethods();
        ArrayList<String> opnames = new ArrayList<String>();
        methods = this.filterMethods(methods, allMethods);
        int i = 0;
        while (i < methods.length) {
            String partType;
            String partName;
            Method m = methods[i];
            String opName = m.getName();
            opnames.add(opName);
            String reqName = String.valueOf(opName) + "Req";
            String resName = String.valueOf(opName) + "Res";
            this.pout.println();
            this.pout.println("<!-- " + portname + "." + opName + " -->");
            this.pout.println("<message name=\"" + reqName + "\">");
            Class<?>[] params = m.getParameterTypes();
            int k = 0;
            while (k < params.length) {
                partName = "part" + k;
                partType = this.writeXsd(params[k]);
                this.pout.println("\t<part name=\"" + partName + "\" type=\"" + partType + "\" />");
                ++k;
            }
            this.pout.println("</message>");
            this.pout.println("<message name=\"" + resName + "\">");
            Class<?> ret = m.getReturnType();
            if (!ret.equals(Void.TYPE)) {
                partName = "ret";
                partType = this.writeXsd(ret);
                this.pout.println("\t<part name=\"" + partName + "\" type=\"" + partType + "\" />");
            }
            this.pout.println("</message>");
            ++i;
        }
        this.xout.println("\t</schema>");
        this.xout.println("</types>");
        this.pout.println(new String(this.bxout.toByteArray()));
        this.pout.println("<portType name=\"" + portname + "PortType\">");
        i = 0;
        while (i < opnames.size()) {
            String opname = (String)opnames.get(i);
            this.pout.println("\t<operation name=\"" + opname + "\">");
            this.pout.println("\t\t<input message=\"tns:" + opname + "Req\"/>");
            this.pout.println("\t\t<output message=\"tns:" + opname + "Res\"/>");
            this.pout.println("\t</operation>");
            ++i;
        }
        this.pout.println("</portType>");
        this.pout.println("");
        this.pout.println("<binding name=\"" + portname + "JavaBinding\" type=\"tns:" + portname + "PortType\">");
        this.pout.println("\t<java:binding/>");
        this.pout.println("\t<format:typeMapping encoding=\"Java\" style=\"Java\">");
        this.pout.println("\t\t<format:typeMap typeName=\"xsd:string\" formatType=\"java.lang.String\"/>");
        this.pout.println("\t\t<format:typeMap typeName=\"xsd:dateTime\" formatType=\"java.util.GregorianCalendar\"/>");
        this.pout.println("\t\t<format:typeMap typeName=\"xsd:double\" formatType=\"double\"/>");
        this.pout.println("\t\t<format:typeMap typeName=\"xsd:float\" formatType=\"float\"/>");
        this.pout.println("\t\t<format:typeMap typeName=\"xsd:long\" formatType=\"long\"/>");
        this.pout.println("\t\t<format:typeMap typeName=\"xsd:int\" formatType=\"int\"/>");
        this.pout.println("\t\t<format:typeMap typeName=\"xsd:boolean\" formatType=\"java.lang.Boolean\"/>");
        i = 0;
        while (i < this.xsdTypes.size()) {
            this.pout.println((String)this.xsdTypes.get(i));
            ++i;
        }
        this.pout.println("\t</format:typeMapping>");
        i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            int partCount = methods[i].getParameterTypes().length;
            boolean hasReturn = !methods[i].getReturnType().equals(Void.TYPE);
            this.pout.println("\t\t<operation name=\"" + name + "\">");
            this.pout.print("\t\t\t<java:operation methodName=\"" + name + "\"");
            if (partCount > 0) {
                this.pout.print(" parameterOrder=\"");
                int k = 0;
                while (k < partCount) {
                    if (k > 0) {
                        this.pout.print(" ");
                    }
                    this.pout.print("part" + k);
                    ++k;
                }
                this.pout.print("\"");
            }
            if (hasReturn) {
                this.pout.print(" returnPart=\"ret\"");
            }
            this.pout.println("/>");
            this.pout.println("\t\t</operation>");
            ++i;
        }
        this.pout.println("</binding>");
        this.pout.println("");
        this.pout.println("<service>");
        this.pout.println("\t<port name=\"" + portname + "JavaService\" binding=\"tns:" + portname + "JavaBinding\">");
        this.pout.println("\t\t<java:address className=\"" + classname + "\"/>");
        this.pout.println("\t</port>");
        this.pout.println("</service>");
        this.pout.println("");
        this.pout.println("<partnerLinkType name=\"" + portname + "PartnerLink\">");
        this.pout.println("\t<role name=\"" + portname + "JavaService\" portType=\"tns:" + portname + "PortType\"/>");
        this.pout.println("</partnerLinkType>");
        this.pout.println("");
        this.pout.println("</definitions>");
        this.wsdl = new String(this.bout.toByteArray());
        StringBuffer sb = new StringBuffer();
        sb.append(this.wsdl.substring(0, this.nsInsert));
        int i2 = 0;
        while (i2 < this.nss.size()) {
            sb.append(this.nss.get(i2));
            ++i2;
        }
        sb.append(this.wsdl.substring(this.nsInsert));
        this.wsdl = sb.toString();
    }

    private Method[] filterMethods(Method[] methods, ArrayList all) {
        ArrayList<Method> list = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            if (all.size() == 0 || all.contains(methods[i].getName())) {
                list.add(methods[i]);
            }
            ++i;
        }
        Collections.sort(list, this);
        i = 0;
        while (i < list.size()) {
            if (i > 0) {
                Method m1 = (Method)list.get(i - 1);
                Method m2 = (Method)list.get(i);
                if (m1.getName().equals(m2.getName())) {
                    list.remove(i--);
                }
            }
            ++i;
        }
        Method[] tmp = new Method[list.size()];
        list.toArray(tmp);
        return tmp;
    }

    private String writeNamespace(String ns) {
        Integer i = (Integer)this.namespaces.get(ns);
        if (i == null) {
            i = new Integer(this.NS++);
            this.namespaces.put(ns, i);
            this.nss.add("\t\t\txmlns:ns" + i + "=\"" + ns + "\"\n");
        }
        return "ns" + i;
    }

    private String getRefFor(Class c) {
        String fullclassname = c.getName();
        String classname = c.getName();
        classname = classname.substring(classname.lastIndexOf(46) + 1);
        if (fullclassname.equals("int") || fullclassname.equals("boolean") || fullclassname.equals("float") || fullclassname.equals("double") || fullclassname.equals("long")) {
            return "xsd:" + classname;
        }
        if (fullclassname.equals("java.lang.String")) {
            return "xsd:string";
        }
        if (fullclassname.equals("java.util.GregorianCalendar")) {
            return "xsd:dateTime";
        }
        String namespace = c.getPackage() == null ? "http://java_empty_namespace" : "http://" + c.getPackage().getName().replace('.', '_');
        String nsref = this.writeNamespace(namespace);
        String ref = String.valueOf(nsref) + ":" + classname;
        return ref;
    }

    private String writeXsd(Class c) {
        String fullclassname = c.getName();
        String classname = c.getName();
        classname = classname.substring(classname.lastIndexOf(46) + 1);
        if (fullclassname.equals("int") || fullclassname.equals("boolean") || fullclassname.equals("float") || fullclassname.equals("double") || fullclassname.equals("long")) {
            return "xsd:" + classname;
        }
        if (fullclassname.equals("java.lang.String")) {
            return "xsd:string";
        }
        if (fullclassname.equals("java.util.GregorianCalendar")) {
            return "xsd:dateTime";
        }
        String namespace = c.getPackage() == null ? "http://java_empty_namespace" : "http://" + c.getPackage().getName().replace('.', '_');
        String nsref = this.writeNamespace(namespace);
        String ref = String.valueOf(nsref) + ":" + classname;
        if (this.xsdMap.get(fullclassname) == null) {
            Field field;
            this.xsdMap.put(fullclassname, fullclassname);
            this.xsdTypes.add("\t\t<format:typeMap typeName=\"" + ref + "\" formatType=\"" + fullclassname + "\"/>");
            this.xout.println();
            this.xout.println("\t\t<!-- conversion of class " + c.getName() + " -->");
            this.xout.println("\t\t<complexType name=\"" + classname + "\">");
            this.xout.println("\t\t\t<sequence>");
            Field[] fields = c.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                field = fields[i];
                if (WsdlGenerator.isInstanceField(field)) {
                    String fieldName = field.getName();
                    Class<?> fieldClazz = field.getType();
                    String fieldType = this.getRefFor(fieldClazz);
                    this.xout.println("\t\t\t\t<element name=\"" + fieldName + "\" type=\"" + fieldType + "\"/>");
                }
                ++i;
            }
            this.xout.println("\t\t\t</sequence>");
            this.xout.println("\t\t</complexType>");
            i = 0;
            while (i < fields.length) {
                field = fields[i];
                if (WsdlGenerator.isInstanceField(field)) {
                    Class<?> fieldClazz = field.getType();
                    this.writeXsd(fieldClazz);
                }
                ++i;
            }
        }
        return ref;
    }

    private static boolean isInstanceField(Field field) {
        try {
            field.setAccessible(true);
            field.get(null);
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: WsdlGenerator <classname> [methodfile]");
            System.out.println("Note: the JVM classpath should include the class you wish to generate WSDL for");
            System.out.println("    methodfile      a file containing a list of methods to convert");
            System.out.println("                    no methodfile means convert all public methods");
        } else {
            ArrayList<String> allMethods = new ArrayList<String>();
            if (args.length > 1) {
                FileInputStream fin = new FileInputStream(args[1]);
                BufferedReader bread = new BufferedReader(new InputStreamReader(fin));
                String line = bread.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        allMethods.add(line);
                    }
                    line = bread.readLine();
                }
            }
            WsdlGenerator gen = new WsdlGenerator(args[0], allMethods);
            System.out.println(gen.getWsdl());
        }
    }

    public int compare(Object arg0, Object arg1) {
        Method m1 = (Method)arg0;
        Method m2 = (Method)arg1;
        return m1.getParameterTypes().length - m2.getParameterTypes().length;
    }
}

