/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDBaseType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDComplexType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDComplexTypeAttribute;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDComplexTypeElement;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDRootElement;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDSimpleType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDType;
import org.eclipse.stp.b2j.core.misc.internal.XMLConfigUtil;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

public class XSDMap {
    String LOG_SOURCE = "XSD Translator";
    TranslatorLog log;
    Util compiler_util;
    NamespaceTranslator nt;
    HashMap topLevel_map = new HashMap();
    ArrayList topLevel_list = new ArrayList();
    HashMap types = new HashMap();

    public XSDRootElement getRootElementTypeByNCName(String ncname) {
        return (XSDRootElement)this.topLevel_map.get(ncname);
    }

    public XSDRootElement getRootElementTypeByQName(String qname) {
        return (XSDRootElement)this.topLevel_map.get(qname);
    }

    public int getRootElementCount() {
        return this.topLevel_list.size();
    }

    public XSDRootElement getRootElement(int index) {
        return (XSDRootElement)this.topLevel_list.get(index);
    }

    public XSDType getType(String qtype) {
        return (XSDType)this.types.get(qtype);
    }

    private void readElement(Element element, XSDComplexType complextype) throws NamespaceException {
        this.nt.addNamespaces(element);
        String name = element.getAttribute("name");
        String type = element.getAttribute("type");
        element.getAttribute("minOccurs");
        element.getAttribute("maxOccurs");
        element.getAttribute("default");
        if (name.equals("")) {
            return;
        }
        if (type.equals("")) {
            ArrayList elems = Util.getAllElements(element);
            boolean typeOK = false;
            int i = 0;
            while (i < elems.size()) {
                Element complex = (Element)elems.get(i);
                String complexname = NamespaceTranslator.getName(complex);
                if (complexname.equals("complexType")) {
                    if (typeOK) {
                        this.log.logWarning(this.LOG_SOURCE, "two anonymous type definitions for one element");
                    }
                    typeOK = true;
                    type = name;
                    complex.setAttribute("name", type);
                    this.readComplexType(complex);
                } else if (complexname.equals("simpleType")) {
                    if (typeOK) {
                        this.log.logWarning(this.LOG_SOURCE, "two anonymous type definitions for one element");
                    }
                    typeOK = true;
                    type = name;
                    complex.setAttribute("name", type);
                    this.readSimpleType(complex);
                } else {
                    this.log.logWarning(this.LOG_SOURCE, "Unknown element tag name underneath <element> \"" + complexname + "\"");
                }
                ++i;
            }
            type = this.nt.qualify(type, true);
        } else {
            type = this.nt.qualify(type, false);
        }
        XSDComplexTypeElement cselem = new XSDComplexTypeElement();
        cselem.name = name;
        cselem.qtype = type;
        complextype.addElement(cselem);
        this.nt.removeNamespaces(element);
    }

    private void readSequence(Element sequence, XSDComplexType complextype) throws NamespaceException {
        this.nt.addNamespaces(sequence);
        ArrayList elements = Util.getAllElements(sequence);
        int i = 0;
        while (i < elements.size()) {
            this.readType((Element)elements.get(i), complextype);
            ++i;
        }
        this.nt.removeNamespaces(sequence);
    }

    private void readComplexContent(Element content, XSDComplexType complextype) throws NamespaceException {
        this.nt.addNamespaces(content);
        ArrayList elements = Util.getAllElements(content);
        int i = 0;
        while (i < elements.size()) {
            this.readType((Element)elements.get(i), complextype);
            ++i;
        }
        this.nt.removeNamespaces(content);
    }

    private void readRestriction(Element restriction, XSDComplexType complextype) throws NamespaceException {
        this.nt.addNamespaces(restriction);
        XSDType ptmp = (XSDType)this.types.get(this.nt.qualify(restriction.getAttribute("base"), false));
        if (ptmp instanceof XSDComplexType) {
            complextype.parent = (XSDComplexType)ptmp;
        }
        ArrayList elements = Util.getAllElements(restriction);
        int i = 0;
        while (i < elements.size()) {
            this.readType((Element)elements.get(i), complextype);
            ++i;
        }
        this.nt.removeNamespaces(restriction);
    }

    private void readExtension(Element extension, XSDComplexType complextype) throws NamespaceException {
        this.nt.addNamespaces(extension);
        XSDType ptmp = (XSDType)this.types.get(this.nt.qualify(extension.getAttribute("base"), false));
        if (ptmp instanceof XSDComplexType) {
            complextype.parent = (XSDComplexType)ptmp;
        }
        ArrayList elements = Util.getAllElements(extension);
        int i = 0;
        while (i < elements.size()) {
            this.readType((Element)elements.get(i), complextype);
            ++i;
        }
        this.nt.removeNamespaces(extension);
    }

    private void readAttribute(Element attribute, XSDComplexType complextype) throws NamespaceException {
        this.nt.addNamespaces(attribute);
        String name = attribute.getAttribute("name");
        String type = attribute.getAttribute("type");
        attribute.getAttribute("use");
        String fixed = attribute.getAttribute("fixed");
        String def = attribute.getAttribute("default");
        String qtype = this.nt.qualify(type, false);
        XSDComplexTypeAttribute attr = new XSDComplexTypeAttribute();
        attr.name = name;
        attr.qtype = qtype;
        attr.fixed = fixed;
        attr.def = def;
        complextype.addAttribute(attr);
        this.nt.removeNamespaces(attribute);
    }

    private void readSimpleType(Element simple) throws NamespaceException {
        this.nt.addNamespaces(simple);
        String name = simple.getAttribute("name");
        String qtype = this.nt.qualify(name, true);
        String base = this.compiler_util.getSimpleTypeBase(this.nt, simple);
        String qbase = this.nt.qualify(base, false);
        this.log.logInfo(this.LOG_SOURCE, "simple type '" + name + "' (" + this.compiler_util.getQNameFromQName(qtype) + ") -> (" + this.compiler_util.getQNameFromQName(qbase) + ")");
        XSDSimpleType type = new XSDSimpleType();
        type.name = name;
        type.qtype = qtype;
        type.qbase = qbase;
        this.types.put(name, type);
        this.types.put(qtype, type);
        this.nt.removeNamespaces(simple);
    }

    private void readComplexType(Element complex) throws NamespaceException {
        this.nt.addNamespaces(complex);
        String name = complex.getAttribute("name");
        String qtype = this.nt.qualify(name, true);
        this.log.logInfo(this.LOG_SOURCE, "complex type '" + name + "' (" + this.compiler_util.getQNameFromQName(qtype) + ")");
        XSDComplexType type = new XSDComplexType();
        type.name = name;
        type.qtype = qtype;
        ArrayList elements = Util.getAllElements(complex);
        int i = 0;
        while (i < elements.size()) {
            this.readType((Element)elements.get(i), type);
            ++i;
        }
        this.types.put(name, type);
        this.types.put(qtype, type);
        this.nt.removeNamespaces(complex);
    }

    private void readTopLevelElement(Element elem) throws NamespaceException {
        this.nt.addNamespaces(elem);
        String name = elem.getAttribute("name");
        String type = elem.getAttribute("type");
        String qname = this.nt.qualify(name, true);
        String qtype = this.nt.qualify(type, false);
        if (type != null && type.length() > 0) {
            this.compiler_util.setXsdTypeDirectAlias(qname, qtype);
        }
        this.log.logInfo(this.LOG_SOURCE, "root element '" + name + "' (" + this.compiler_util.getQNameFromQName(qtype) + ")");
        String ns = this.nt.getNamespace(name, true);
        XSDRootElement root = new XSDRootElement();
        root.name = name;
        root.namespace = ns;
        root.qname = qname;
        root.qtype = qtype;
        this.topLevel_map.put(name, root);
        this.topLevel_map.put(qname, root);
        this.topLevel_list.add(root);
        this.nt.removeNamespaces(elem);
    }

    private void readType(Element type, XSDComplexType complextype) throws NamespaceException {
        String tag = NamespaceTranslator.getName(type);
        if (complextype != null) {
            if (tag.equals("element")) {
                this.readElement(type, complextype);
            } else if (tag.equals("sequence")) {
                this.readSequence(type, complextype);
            } else if (tag.equals("attribute")) {
                this.readAttribute(type, complextype);
            } else if (tag.equals("complexContent")) {
                this.readComplexContent(type, complextype);
            } else if (tag.equals("restriction")) {
                this.readRestriction(type, complextype);
            } else if (tag.equals("extension")) {
                this.readExtension(type, complextype);
            } else if (!tag.equals("annotation") && !tag.equals("import")) {
                this.log.logWarning(this.LOG_SOURCE, "ignored element [" + tag + "] under complex type");
            }
        } else if (tag.equals("element")) {
            this.readTopLevelElement(type);
        } else if (!tag.equals("annotation")) {
            this.log.logWarning(this.LOG_SOURCE, "ignored element [" + tag + "]");
        }
        if (tag.equals("simpleType")) {
            this.readSimpleType(type);
        } else if (tag.equals("complexType")) {
            this.readComplexType(type);
        }
    }

    private void readSchema(Element schema) throws NamespaceException {
        this.nt.addNamespaces(schema);
        ArrayList elements = Util.getAllElements(schema);
        int i = 0;
        while (i < elements.size()) {
            this.readType((Element)elements.get(i), null);
            ++i;
        }
        this.nt.removeNamespaces(schema);
    }

    public XSDMap(Util compiler_util, TranslatorLog log, String[] xsdxml) throws Exception {
        this(compiler_util, log, xsdxml, new String[0]);
    }

    public XSDMap(Util compiler_util, TranslatorLog log, String[] xsdxml, String[] wsdlxml) throws Exception {
        this.log = log;
        this.compiler_util = compiler_util;
        this.nt = compiler_util.createNamespaceTranslator();
        int i = 0;
        while (i < xsdxml.length) {
            DocumentBuilder builder = XMLConfigUtil.getDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xsdxml[i].getBytes()));
            this.readSchema(doc.getDocumentElement());
            ++i;
        }
        NamespaceTranslator tmpNT = compiler_util.createNamespaceTranslator();
        String[] baseTypes = Util.getXSDBaseTypes();
        int i2 = 0;
        while (i2 < baseTypes.length) {
            XSDBaseType type = new XSDBaseType();
            type.qtype = tmpNT.qualify(baseTypes[i2], false);
            this.types.put(type.qtype, type);
            ++i2;
        }
        i2 = 0;
        while (i2 < wsdlxml.length) {
            DocumentBuilder builder = XMLConfigUtil.getDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(wsdlxml[i2].getBytes()));
            Element docElem = doc.getDocumentElement();
            this.nt.addNamespaces(docElem);
            ArrayList elems = Util.getAllElements(docElem);
            int k = 0;
            while (k < elems.size()) {
                Element types = (Element)elems.get(k);
                this.nt.addNamespaces(types);
                String tag = NamespaceTranslator.getName(types);
                if (tag.equals("types")) {
                    ArrayList schemas = Util.getAllElements(types);
                    int z = 0;
                    while (z < schemas.size()) {
                        Element schema = (Element)schemas.get(z);
                        String schematag = NamespaceTranslator.getName(schema);
                        if (schematag.equals("schema")) {
                            log.logInfo(this.LOG_SOURCE, "found XSD schema in WSDL document");
                            this.readSchema(schema);
                        }
                        ++z;
                    }
                }
                this.nt.removeNamespaces(types);
                ++k;
            }
            this.nt.removeNamespaces(docElem);
            ++i2;
        }
    }
}

