/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPFactory;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPServerTransportListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPUtils;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPException;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.AlwaysCorrelatable;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.Correlatable;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.CorrelatedMultiQueuedBlockingMap;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;

public class SOAPServer
implements SOAPServerTransportListener {
    private static Correlatable[] no_correlation = new Correlatable[]{new AlwaysCorrelatable()};
    public static long TIMEOUT = 30000L;
    private static SOAPServer INSTANCE = new SOAPServer();
    private static Object accepted_urls_LOCK = new Object();
    private static HashMap accepted_urls = new HashMap();
    private static final String REQ = ">";
    private static final String RES = "<";
    private static final String LISTENFOR = "@";
    UIDPool uids = new UIDPool();
    private static CorrelatedMultiQueuedBlockingMap conversations = new CorrelatedMultiQueuedBlockingMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int acceptAddress(WSEndpointReference epr, String transportURI, boolean rpc_bound) throws Exception {
        Object object = accepted_urls_LOCK;
        synchronized (object) {
            Integer port = (Integer)accepted_urls.get(epr.getAddress());
            if (port != null) {
                return port;
            }
            URL url = new URL(epr.getAddress());
            port = url.getPort() == -1 ? (url.getProtocol().equalsIgnoreCase("https") ? new Integer(443) : new Integer(80)) : new Integer(url.getPort());
            SOAPFactory.addServerTransportListenerForEPR(epr, transportURI, rpc_bound, INSTANCE);
            accepted_urls.put(epr.getAddress(), port);
            return port;
        }
    }

    private static String getDocumentRequestKey(int httpport, String soapAction) {
        if (soapAction == null) {
            return String.valueOf(httpport) + ":";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(REQ);
        sb.append(httpport);
        sb.append(":");
        sb.append(soapAction);
        return sb.toString();
    }

    private static String getDocumentResponseKey(int httpport, String soapAction, String replyConversation) {
        if (soapAction == null) {
            return String.valueOf(httpport) + ":";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(RES);
        sb.append(replyConversation);
        sb.append(":");
        sb.append(httpport);
        sb.append(":");
        sb.append(soapAction);
        return sb.toString();
    }

    private static String getRpcRequestKey(int httpport, String soapAction, String operationNamespace, String operation) {
        if (soapAction == null) {
            soapAction = "";
        }
        if (operation == null) {
            operation = "";
        }
        if (operationNamespace == null) {
            operationNamespace = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(REQ);
        sb.append(httpport);
        sb.append(":");
        sb.append(soapAction);
        sb.append(":");
        sb.append(operationNamespace);
        sb.append(":");
        sb.append(operation);
        return sb.toString();
    }

    private static String getRpcResponseKey(int httpport, String soapAction, String operationNamespace, String operation, String replyConversation) {
        if (soapAction == null) {
            soapAction = "";
        }
        if (operation == null) {
            operation = "";
        }
        if (operationNamespace == null) {
            operationNamespace = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(RES);
        sb.append(replyConversation);
        sb.append(":");
        sb.append(httpport);
        sb.append(":");
        sb.append(soapAction);
        sb.append(":");
        sb.append(operationNamespace);
        sb.append(":");
        sb.append(operation);
        return sb.toString();
    }

    public static String receive(WSEndpointReference epr, String transportUri, boolean rpc_type, String operationNamespace, String operation, String soapAction) throws Exception {
        return SOAPServer.receive(epr, no_correlation[0], "", transportUri, rpc_type, operationNamespace, operation, soapAction);
    }

    public static String receive(WSEndpointReference epr, Correlatable correlatable, String replyConversation, String transportUri, boolean rpc_type, String operationNamespace, String operation, String soapAction) throws Exception {
        int port = SOAPServer.acceptAddress(epr, transportUri, rpc_type);
        Correlatable[] correlation = new Correlatable[]{correlatable};
        String[] key = new String[1];
        String[][] reskey = new String[1][];
        if (rpc_type) {
            key[0] = SOAPServer.getRpcRequestKey(port, operationNamespace, operation, soapAction);
            reskey[0] = new String[]{SOAPServer.getRpcResponseKey(port, operationNamespace, operation, soapAction, replyConversation)};
        } else {
            key[0] = SOAPServer.getDocumentRequestKey(port, soapAction);
            reskey[0] = new String[]{SOAPServer.getDocumentResponseKey(port, soapAction, replyConversation)};
        }
        Message reqmsg = conversations.get(key, correlation, 0L);
        String msg = (String)reqmsg.get(0);
        String uid = (String)reqmsg.get(1);
        Message listenformsg = new Message();
        int i = 0;
        while (i < reskey[0].length) {
            listenformsg.append(reskey[0][i]);
            ++i;
        }
        conversations.put(uid, listenformsg);
        msg = rpc_type ? SOAPUtils.basicRemoveSoapEnvelopeRPC(msg) : SOAPUtils.basicRemoveSoapEnvelopeDocument(msg);
        return msg;
    }

    public static String[] pick(WSEndpointReference[] epr, String[] transportUri, boolean[] rpc_type, String[] operationNamespace, String[] operation, String[] soapAction, long timeout) throws Exception {
        Object[] correlation = new Correlatable[epr.length];
        Arrays.fill(correlation, no_correlation[0]);
        Object[] replyConversation = new String[epr.length];
        Arrays.fill(replyConversation, "");
        return SOAPServer.pick(epr, (Correlatable[])correlation, (String[])replyConversation, transportUri, rpc_type, operationNamespace, operation, soapAction, timeout);
    }

    public static String[] pick(WSEndpointReference[] epr, Correlatable[] correlatable, String[] replyConversation, String[] transportUri, boolean[] rpc_type, String[] operationNamespace, String[] operation, String[] soapAction, long timeout) throws Exception {
        Message reqmsg;
        String[] key = new String[epr.length];
        String[][] reskey = new String[epr.length][];
        int i = 0;
        while (i < key.length) {
            int port = SOAPServer.acceptAddress(epr[i], transportUri[i], rpc_type[i]);
            if (rpc_type[i]) {
                key[i] = SOAPServer.getRpcRequestKey(port, operationNamespace[i], operation[i], soapAction[i]);
                reskey[i] = new String[]{SOAPServer.getRpcResponseKey(port, operationNamespace[i], operation[i], soapAction[i], replyConversation[i])};
            } else {
                key[i] = SOAPServer.getDocumentRequestKey(port, soapAction[i]);
                reskey[i] = new String[]{SOAPServer.getDocumentResponseKey(port, soapAction[i], replyConversation[i])};
            }
            ++i;
        }
        try {
            reqmsg = conversations.get(key, correlatable, timeout);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        String receive_key = (String)reqmsg.pop();
        String[] msg = new String[5];
        int i2 = 0;
        while (i2 < key.length) {
            if (key[i2].equals(receive_key)) {
                msg[0] = operationNamespace[i2];
                msg[1] = operation[i2];
                msg[2] = soapAction[i2];
                msg[3] = (String)reqmsg.get(0);
                String uid = (String)reqmsg.get(1);
                Message listenformsg = new Message();
                int k = 0;
                while (k < reskey[i2].length) {
                    listenformsg.append(reskey[i2][k]);
                    ++k;
                }
                conversations.put(uid, listenformsg);
                if (rpc_type[i2]) {
                    msg[3] = SOAPUtils.basicRemoveSoapEnvelopeRPC(msg[3]);
                    break;
                }
                msg[3] = SOAPUtils.basicRemoveSoapEnvelopeDocument(msg[3]);
                break;
            }
            ++i2;
        }
        return msg;
    }

    public static void reply(WSEndpointReference epr, String replyConversation, String transportUri, boolean rpc_type, String operationNamespace, String operation, String soapAction, String wsdl_message) throws Exception {
        String key;
        int port = SOAPServer.acceptAddress(epr, transportUri, rpc_type);
        if (rpc_type) {
            operation = String.valueOf(operation) + "Response";
            key = SOAPServer.getRpcResponseKey(port, operationNamespace, operation, soapAction, replyConversation);
            wsdl_message = wsdl_message != null ? SOAPUtils.basicWrapInSoapEnvelopeRPC(wsdl_message, operationNamespace, operation) : "";
        } else {
            key = SOAPServer.getDocumentResponseKey(port, soapAction, replyConversation);
            wsdl_message = wsdl_message != null ? SOAPUtils.basicWrapInSoapEnvelopeDocument(wsdl_message) : "";
        }
        Message msg = new Message();
        msg.append(wsdl_message);
        conversations.put(key, msg);
    }

    public String doRequest(int httpport, boolean rpc_type, String operationNamespace, String operation, String soapAction, String payload) throws Exception {
        try {
            String key = rpc_type ? SOAPServer.getRpcRequestKey(httpport, soapAction, operationNamespace, operation) : SOAPServer.getDocumentRequestKey(httpport, soapAction);
            int myuid = this.uids.getUID();
            Message reqmsg = new Message();
            reqmsg.append(payload);
            reqmsg.append(LISTENFOR + myuid);
            try {
                Message listenformsg = conversations.putAndGet(key, reqmsg, new String[]{LISTENFOR + myuid}, no_correlation, TIMEOUT);
                this.uids.releaseUID(myuid);
                String[] listenforkeys = new String[listenformsg.length()];
                Correlatable[] corrs = new Correlatable[listenforkeys.length];
                int i = 0;
                while (i < listenforkeys.length) {
                    listenforkeys[i] = (String)listenformsg.get(i);
                    corrs[i] = no_correlation[0];
                    ++i;
                }
                Message resmsg = conversations.get(listenforkeys, corrs, 0L);
                String response = (String)resmsg.get(0);
                return response;
            }
            catch (InterruptedException interruptedException) {
                this.uids.releaseUID(myuid);
                throw new HTTPException("Operation timed out (" + TIMEOUT + " ms)");
            }
        }
        catch (HTTPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HTTPException("\n-----\n" + SOAPUtils.getStackTrace(e) + "\n-----\n");
        }
    }
}

