/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.xml.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.xml.internal.FastByteArrayInputStream;
import org.eclipse.stp.b2j.core.xml.internal.XMLParserListener;

public class FastXMLParser {
    private static final boolean DEBUG = false;
    private static final boolean ALWAYS_BUFFERED = false;
    InputStream input;
    private static final byte ROOT = 0;
    private static final byte TEXT_NODE = 1;
    private static final byte OPEN_TAG = 2;
    private static final byte TAG_NAME = 3;
    private static final byte TAG_ATTRIBUTE = 4;
    private static final byte CLOSE_TAG = 5;
    private static final byte ID_OR_ATTRIBUTE = 6;
    int pch = 0;
    int ch = 0;
    int line = 1;
    int column = 1;
    XMLParserListener curlistener;

    public FastXMLParser() {
    }

    public FastXMLParser(String in) throws IOException {
        this.setInput(in);
    }

    public FastXMLParser(StringBuffer in) throws IOException {
        this.setInput(in);
    }

    public FastXMLParser(InputStream in) throws IOException {
        this.setInput(in);
    }

    public void setInput(InputStream in) throws IOException {
        this.input = in;
        this.ch = this.input.read();
        this.line = 1;
        this.column = 1;
    }

    public void setInput(String in) throws IOException {
        this.setInput(new FastByteArrayInputStream(in.getBytes()));
    }

    public void setInput(StringBuffer in) throws IOException {
        this.setInput(new FastByteArrayInputStream(in.toString().getBytes()));
    }

    public void parse(XMLParserListener listener, InputStream in) throws Exception {
        this.setInput(in);
        this.parse(listener);
    }

    public void parse(XMLParserListener listener) throws Exception {
        this.curlistener = listener;
        listener.startDocument();
        boolean ignored_tag = false;
        boolean start_tag = true;
        String tag_name = "ERROR";
        StringBuffer tmp = new StringBuffer(128);
        HashMap<String, String> attributes = null;
        int mode = 1;
        int startLine = -1;
        while (true) {
            switch (mode) {
                case 1: {
                    tmp.setLength(0);
                    startLine = this.line;
                    this.parseText(tmp);
                    if (this.peekChar() == -1) {
                        listener.endDocument();
                        return;
                    }
                    if (tmp.length() > 0) {
                        this.convertValue(tmp);
                        listener.text(tmp.toString(), startLine, this.line);
                    }
                    mode = 2;
                    break;
                }
                case 2: {
                    if (this.nextChar() != 60) {
                        this.error("expected open tag < not " + this.prevChar());
                    }
                    if (this.peekChar() == 33) {
                        this.nextChar();
                        if (this.peekChar() == 45) {
                            if (this.nextChar() != 45) {
                                this.error("expected comment -");
                            }
                            if (this.peekChar() != 45) break;
                            this.nextChar();
                            startLine = this.line;
                            StringBuffer zz = new StringBuffer();
                            this.parseComment(zz);
                            listener.comment(zz.toString(), startLine, this.line);
                            mode = 1;
                            break;
                        }
                        if (this.peekChar() == 91) {
                            this.nextChar();
                            if (this.nextChar() != 67) {
                                this.error("expected ![CDATA[ comment C");
                            }
                            if (this.nextChar() != 68) {
                                this.error("expected ![CDATA[ comment D");
                            }
                            if (this.nextChar() != 65) {
                                this.error("expected ![CDATA[ comment A");
                            }
                            if (this.nextChar() != 84) {
                                this.error("expected ![CDATA[ comment T");
                            }
                            if (this.nextChar() != 65) {
                                this.error("expected ![CDATA[ comment A");
                            }
                            if (this.nextChar() != 91) {
                                this.error("expected ![CDATA[ comment [");
                            }
                            this.parseCDATA(null);
                            mode = 1;
                            break;
                        }
                        start_tag = true;
                        ignored_tag = true;
                        mode = 6;
                        this.parseWhitespace(null);
                        break;
                    }
                    if (this.peekChar() == 63) {
                        this.nextChar();
                        start_tag = true;
                        ignored_tag = true;
                    } else if (this.peekChar() == 47) {
                        this.nextChar();
                        start_tag = false;
                    } else {
                        attributes = null;
                        start_tag = true;
                    }
                    ignored_tag = false;
                    mode = 3;
                    this.parseWhitespace(null);
                    break;
                }
                case 3: {
                    startLine = this.line;
                    tmp.setLength(0);
                    this.parseIdentifier(tmp);
                    if (tmp.length() == 0) {
                        this.error("expected tag name (or some other valid open tag like \"<!--\", \"<!DOCTYP\" or \"<![CDATA[\" )");
                    }
                    tag_name = tmp.toString();
                    this.parseWhitespace(null);
                    mode = 4;
                    break;
                }
                case 6: {
                    if (this.peekChar() == 47) {
                        mode = 5;
                        break;
                    }
                    if (this.peekChar() == 63) {
                        mode = 5;
                        break;
                    }
                    if (this.peekChar() == 62) {
                        mode = 5;
                        break;
                    }
                    if (this.peekChar() == 34 || this.peekChar() == 39) {
                        this.parseQuoted(null);
                    } else {
                        this.parseIdentifier(null);
                        this.parseWhitespace(null);
                        if (this.peekChar() == 61) {
                            this.nextChar();
                            this.parseWhitespace(null);
                            this.parseQuoted(null);
                        }
                    }
                    this.parseWhitespace(null);
                    break;
                }
                case 4: {
                    if (this.peekChar() == 47) {
                        mode = 5;
                        break;
                    }
                    if (this.peekChar() == 63) {
                        mode = 5;
                        break;
                    }
                    if (this.peekChar() == 62) {
                        mode = 5;
                        break;
                    }
                    if (!start_tag) {
                        this.error("attributes found in end tag");
                    }
                    tmp.setLength(0);
                    this.parseIdentifier(tmp);
                    String key = tmp.toString();
                    if (key.length() == 0) {
                        this.error("expected tag attribute key (blah=\"...\")");
                    }
                    this.parseWhitespace(null);
                    if (this.nextChar() != 61) {
                        this.error("expected attribute equals = (blah=\"...\")");
                    }
                    this.parseWhitespace(null);
                    if (this.peekChar() != 34 && this.peekChar() != 39) {
                        this.error("expected attribute value in quotes (blah=\"value\")");
                    }
                    tmp.setLength(0);
                    this.parseQuoted(tmp);
                    this.convertValue(tmp);
                    String value = tmp.toString();
                    if (attributes == null) {
                        attributes = new HashMap<String, String>(16, 0.6f);
                    }
                    attributes.put(key, value);
                    this.parseWhitespace(null);
                    break;
                }
                case 5: {
                    if (this.peekChar() == 63) {
                        this.nextChar();
                        if (this.nextChar() != 62) {
                            this.error("expected close tag \"?>\" at end of xml spec tag");
                        }
                    } else if (this.peekChar() == 47) {
                        if (!start_tag) {
                            this.error("invalid close tag \"/>\" on end tag, close tag should be \">\" on end tag");
                        }
                        this.nextChar();
                        if (this.nextChar() != 62) {
                            this.error("expected close tag > (e.g. \"<mytag />\")");
                        }
                        if (!ignored_tag) {
                            listener.startElement(tag_name, attributes, startLine);
                            listener.endElement(tag_name, this.line);
                        }
                        ignored_tag = false;
                    } else {
                        if (this.nextChar() != 62) {
                            this.error("expected close tag >");
                        }
                        if (!ignored_tag) {
                            if (start_tag) {
                                listener.startElement(tag_name, attributes, startLine);
                            } else {
                                listener.endElement(tag_name, this.line);
                            }
                        }
                        ignored_tag = false;
                    }
                    mode = 1;
                }
            }
        }
    }

    private int peekChar() throws IOException {
        return this.ch;
    }

    private int nextChar() throws IOException {
        this.pch = this.ch;
        this.ch = this.input.read();
        if (this.pch == 10) {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
        return this.pch;
    }

    private char prevChar() throws IOException {
        return (char)this.pch;
    }

    private void error(String s) throws Exception {
        throw new Exception(String.valueOf(s) + ", line " + this.line + ", column " + this.column + " pch=" + this.prevChar() + " (" + this.prevChar() + ") peek=" + (char)this.peekChar() + " (" + this.peekChar() + ")");
    }

    private int indexOf(StringBuffer sb, char c, int index) {
        int i = index;
        while (i < sb.length()) {
            char x = sb.charAt(i);
            if (c == x) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void convertValue(StringBuffer sb) throws IOException {
        int i = 0;
        while (i < sb.length()) {
            char ch = sb.charAt(i);
            if (ch == '&') {
                int len = sb.length() - i;
                boolean matched = false;
                if (len > 3) {
                    if (sb.charAt(i + 1) == '#') {
                        int end_parse = this.indexOf(sb, ';', i + 1);
                        if (end_parse != -1) {
                            char ccode = (char)Integer.parseInt(sb.substring(i + 2, end_parse));
                            sb.replace(i, end_parse + 1, String.valueOf(ccode));
                        }
                        matched = true;
                    } else if (sb.charAt(i + 1) == 'l' && sb.charAt(i + 2) == 't' && sb.charAt(i + 3) == ';') {
                        sb.replace(i, i + 4, "<");
                        matched = true;
                    } else if (sb.charAt(i + 1) == 'g' && sb.charAt(i + 2) == 't' && sb.charAt(i + 3) == ';') {
                        sb.replace(i, i + 4, ">");
                        matched = true;
                    }
                }
                if (!matched && len > 4 && sb.charAt(i + 1) == 'a' && sb.charAt(i + 2) == 'm' && sb.charAt(i + 3) == 'p' && sb.charAt(i + 4) == ';') {
                    sb.replace(i, i + 5, "&");
                    matched = true;
                }
                if (!matched && len > 5) {
                    if (sb.charAt(i + 1) == 'q' && sb.charAt(i + 2) == 'u' && sb.charAt(i + 3) == 'o' && sb.charAt(i + 4) == 't' && sb.charAt(i + 5) == ';') {
                        sb.replace(i, i + 6, "\"");
                    } else if (sb.charAt(i + 1) == 'a' && sb.charAt(i + 2) == 'p' && sb.charAt(i + 3) == 'o' && sb.charAt(i + 4) == 's' && sb.charAt(i + 5) == ';') {
                        sb.replace(i, i + 6, "'");
                    }
                }
            }
            ++i;
        }
    }

    private int parseCDATA(StringBuffer sb) throws IOException {
        int len = 0;
        int ch = this.peekChar();
        int count = 0;
        while (ch > 31 && ch < 127 || ch > 127 && ch < 255 || ch == 9 || ch == 10) {
            if (count == 0 && ch == 93) {
                ++count;
            } else if (count == 1 && ch == 93) {
                ++count;
            } else {
                if (count == 2 && ch == 62) {
                    this.nextChar();
                    if (sb != null) {
                        sb.setLength(sb.length() - 2);
                    }
                    return len - 2;
                }
                count = 0;
            }
            if (sb != null) {
                sb.append((char)ch);
            }
            ++len;
            this.nextChar();
            ch = this.peekChar();
        }
        return len;
    }

    private int parseComment(StringBuffer sb) throws IOException {
        int len = 0;
        int ch = this.peekChar();
        int count = 0;
        while (ch != -1) {
            if (count == 0 && ch == 45) {
                ++count;
            } else if (count == 1 && ch == 45) {
                ++count;
            } else {
                if (count == 2 && ch == 62) {
                    this.nextChar();
                    if (sb != null) {
                        sb.setLength(sb.length() - 2);
                    }
                    return len - 2;
                }
                count = 0;
            }
            if (sb != null) {
                sb.append((char)ch);
            }
            ++len;
            this.nextChar();
            ch = this.peekChar();
        }
        return len;
    }

    private int parseIdentifier(StringBuffer sb) throws IOException {
        int len = 0;
        int ch = this.peekChar();
        while (ch > 43 && ch < 59 || ch > 64 && ch < 91 || ch > 96 && ch < 123 || ch == 95) {
            if (sb != null) {
                sb.append((char)ch);
            }
            ++len;
            this.nextChar();
            ch = this.peekChar();
        }
        return len;
    }

    private int parseQuoted(StringBuffer sb) throws IOException {
        int len = 0;
        int quote = this.nextChar();
        int ch = this.peekChar();
        while (ch > 31 && ch < 127 || ch > 127 && ch < 255) {
            if (ch == quote) {
                this.nextChar();
                return len;
            }
            if (sb != null) {
                sb.append((char)ch);
            }
            ++len;
            this.nextChar();
            ch = this.peekChar();
        }
        return len;
    }

    private int parseText(StringBuffer sb) throws IOException {
        int len = 0;
        int ch = this.peekChar();
        while (ch != -1) {
            if (ch == 60) {
                return len;
            }
            if (sb != null) {
                sb.append((char)ch);
            }
            ++len;
            this.nextChar();
            ch = this.peekChar();
        }
        return len;
    }

    private int parseWhitespace(StringBuffer sb) throws IOException {
        int len = 0;
        int ch = this.peekChar();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            if (sb != null) {
                sb.append((char)ch);
            }
            ++len;
            this.nextChar();
            ch = this.peekChar();
        }
        return len;
    }
}

